/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.hc;

import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.hc.SeaCatClientConnection;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponseFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;

public class SeaCatClientConnManager
implements ClientConnectionManager {
    protected final SchemeRegistry registry;
    protected final HttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
    protected final Reactor reactor;

    public SeaCatClientConnManager(Reactor reactor) {
        this.reactor = reactor;
        this.registry = new SchemeRegistry();
        this.registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        this.registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.registry;
    }

    public ClientConnectionRequest requestConnection(HttpRoute httpRoute, Object state) {
        return new SeaCatClientConnection(httpRoute, this.responseFactory, this.reactor, state);
    }

    public void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
    }

    public void closeIdleConnections(long l, TimeUnit timeUnit) {
    }

    public void closeExpiredConnections() {
    }

    public void shutdown() {
    }
}

