/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;

public class FramePool {
    private final Stack<ByteBuffer> stack = new Stack();
    private final int lowWaterMark;
    private final int highWaterMark;
    private final int frameCapacity;
    private final AtomicInteger totalCount = new AtomicInteger(0);
    private static final String LOW_WATER_MARK = "lowWaterMark";
    private static final String HIGH_WATER_MARK = "highWaterMark";
    private static final String FRAME_CAPACITY = "frameCapacity";
    protected double before = 0.0;

    public FramePool() {
        Preferences prefs = Preferences.userNodeForPackage(FramePool.class);
        this.lowWaterMark = prefs.getInt(LOW_WATER_MARK, 16);
        this.highWaterMark = prefs.getInt(HIGH_WATER_MARK, 40960);
        this.frameCapacity = prefs.getInt(FRAME_CAPACITY, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer borrow(String reason) throws IOException {
        ByteBuffer frame;
        try {
            Stack<ByteBuffer> stack = this.stack;
            synchronized (stack) {
                frame = this.stack.pop();
            }
        }
        catch (EmptyStackException e) {
            if (this.totalCount.intValue() >= this.highWaterMark) {
                throw new IOException("No more available frames in the pool.");
            }
            frame = this.createByteBuffer();
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveBack(ByteBuffer frame) {
        if (this.totalCount.intValue() > this.lowWaterMark) {
            frame.clear();
            this.totalCount.decrementAndGet();
        } else {
            frame.clear();
            Stack<ByteBuffer> stack = this.stack;
            synchronized (stack) {
                this.stack.push(frame);
            }
        }
    }

    private synchronized ByteBuffer createByteBuffer() {
        this.totalCount.incrementAndGet();
        ByteBuffer frame = ByteBuffer.allocateDirect(this.frameCapacity);
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Stack<ByteBuffer> stack = this.stack;
        synchronized (stack) {
            return this.stack.size();
        }
    }

    public int capacity() {
        return this.totalCount.get();
    }

    public void heartBeat(double now) {
    }
}

