/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import com.teskalabs.seacat.android.client.core.seacatcc;
import com.teskalabs.seacat.android.client.util.RC;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SeaCatPlugin {
    private static ArrayList<SeaCatPlugin> plugins = new ArrayList();
    private static boolean capabilitiesCommited = false;

    static synchronized void commitCapabilities(Context context) {
        if (capabilitiesCommited) {
            throw new RuntimeException("SeaCat Capabilities are already comited!");
        }
        ArrayList<String> caps = new ArrayList<String>();
        for (SeaCatPlugin p : plugins) {
            Properties pcaps = p.getCapabilities();
            if (pcaps == null) continue;
            for (String name : pcaps.stringPropertyNames()) {
                caps.add(String.format("%s\u001f%s", name, pcaps.getProperty(name)));
            }
        }
        caps.add(String.format("%s\u001f%s", "plv", Build.VERSION.RELEASE));
        caps.add(String.format("%s\u001f%s", "pls", Build.VERSION.SDK_INT));
        caps.add(String.format("%s\u001f%s", "pli", Build.VERSION.INCREMENTAL));
        caps.add(String.format("%s\u001f%s", "plB", Build.BRAND));
        caps.add(String.format("%s\u001f%s", "plf", Build.FINGERPRINT));
        caps.add(String.format("%s\u001f%s", "plI", Build.ID));
        caps.add(String.format("%s\u001f%s", "plm", Build.MANUFACTURER));
        caps.add(String.format("%s\u001f%s", "plM", Build.MODEL));
        caps.add(String.format("%s\u001f%s", "plp", Build.PRODUCT));
        caps.add(String.format("%s\u001f%s", "plt", Build.TAGS));
        caps.add(String.format("%s\u001f%s", "plT", Build.TYPE));
        caps.add(String.format("%s\u001f%s", "plU", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")));
        caps.add(String.format("%s\u001f%s", "hwb", Build.BOARD));
        caps.add(String.format("%s\u001f%s", "hwd", Build.DEVICE));
        caps.add(String.format("%s\u001f%s", "hwS", Build.SERIAL));
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        caps.add(String.format("%s\u001f%sx%s", "dpr", dm.widthPixels, dm.heightPixels));
        caps.add(String.format("%s\u001f%s", "dpi", dm.densityDpi));
        caps.add(String.format("%s\u001f%s", "dpden", Float.valueOf(dm.density)));
        caps.add(String.format("%s\u001f%s", "dpxdpi", Float.valueOf(dm.xdpi)));
        caps.add(String.format("%s\u001f%s", "dpydpi", Float.valueOf(dm.ydpi)));
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            caps.add(String.format("%s\u001f%s", "apN", pInfo.versionName));
            caps.add(String.format("%s\u001f%s", "apV", pInfo.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"SeaCat", (String)"Cannot get package info of the application");
        }
        caps.add(null);
        String[] caparr = new String[caps.size()];
        caparr = caps.toArray(caparr);
        int rc = seacatcc.capabilities_store(caparr);
        RC.checkAndLogError("seacatcc.capabilities_store", rc);
        if (rc == 0) {
            capabilitiesCommited = true;
        }
    }

    public SeaCatPlugin() {
        plugins.add(this);
    }

    public abstract Properties getCapabilities();
}

