/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client;

import android.content.Context;
import android.util.Log;
import com.teskalabs.seacat.android.client.CSR;
import com.teskalabs.seacat.android.client.SeaCatInternals;
import com.teskalabs.seacat.android.client.SeaCatPlugin;
import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.seacatcc;
import com.teskalabs.seacat.android.client.hc.SeaCatHttpClient;
import com.teskalabs.seacat.android.client.http.URLConnection;
import com.teskalabs.seacat.android.client.ping.Ping;
import com.teskalabs.seacat.android.client.socket.SocketConfig;
import com.teskalabs.seacat.android.client.util.RC;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.http.client.HttpClient;
import org.apache.http.params.HttpParams;

public final class SeaCatClient {
    private static Reactor reactor = null;
    public static final String CATEGORY_SEACAT = "mobi.seacat.client.intent.category.SEACAT";
    public static final String ACTION_SEACAT_EVLOOP_STARTED = "mobi.seacat.client.intent.action.EVLOOP_STARTED";
    public static final String ACTION_SEACAT_GWCONN_CONNECTED = "mobi.seacat.client.intent.action.GWCONN_CONNECTED";
    public static final String ACTION_SEACAT_GWCONN_RESET = "mobi.seacat.client.intent.action.GWCONN_RESET";
    public static final String ACTION_SEACAT_CSR_NEEDED = "mobi.seacat.client.intent.action.CSR_NEEDED";
    public static final String ACTION_SEACAT_STATE_CHANGED = "mobi.seacat.client.intent.action.STATE_CHANGED";
    public static final String ACTION_SEACAT_CLIENTID_CHANGED = "mobi.seacat.client.intent.action.CLIENTID_CHANGED";
    public static final String EXTRA_STATE = "SEACAT_STATE";
    public static final String EXTRA_PREV_STATE = "SEACAT_PREV_STATE";
    public static final String EXTRA_CLIENT_ID = "SEACAT_CLIENT_ID";
    public static final String EXTRA_CLIENT_TAG = "SEACAT_CLIENT_TAG";

    public static void initialize(Context context) {
        SeaCatClient.initialize(context, CSR.createDefault(), null);
    }

    public static void initialize(Context context, String applicationIdSuffix) {
        SeaCatClient.initialize(context, CSR.createDefault(), applicationIdSuffix);
    }

    public static void initialize(Context context, Runnable CSRworker) {
        SeaCatClient.initialize(context, CSRworker, null);
    }

    public static void initialize(Context context, Runnable CSRworker, String applicationIdSuffix) {
        SeaCatInternals.applicationIdSuffix = applicationIdSuffix;
        SeaCatClient.setCSRWorker(CSRworker);
        try {
            reactor = new Reactor(context);
        }
        catch (IOException e) {
            Log.e((String)"SeaCat", (String)"Exception during SeaCat reactor start", (Throwable)e);
        }
        SeaCatPlugin.commitCapabilities(context);
    }

    public static void broadcastState() {
        Reactor reactor = SeaCatClient.getReactor();
        if (reactor != null) {
            reactor.broadcastState();
        }
    }

    static Reactor getReactor() {
        return reactor;
    }

    public static void ping(Ping ping) throws IOException {
        SeaCatClient.getReactor().pingFactory.ping(reactor, ping);
    }

    public static void ping() throws IOException {
        SeaCatClient.getReactor().pingFactory.ping(reactor, new Ping(){});
    }

    public static HttpURLConnection open(URL url) throws IOException {
        return new URLConnection(SeaCatClient.getReactor(), url, 3);
    }

    public static HttpURLConnection open(String url) throws IOException {
        return SeaCatClient.open(new URL(url));
    }

    public static HttpClient httpClient(HttpParams params) {
        return new SeaCatHttpClient(params, SeaCatClient.getReactor());
    }

    public static HttpClient httpClient() {
        return new SeaCatHttpClient(SeaCatClient.getReactor());
    }

    public static String getState() {
        return seacatcc.state();
    }

    public static void connect() throws IOException {
        int rc = seacatcc.yield('c');
        RC.checkAndThrowIOException("seacatcc.yield(connect)", rc);
    }

    public static void disconnect() throws IOException {
        int rc = seacatcc.yield('d');
        RC.checkAndThrowIOException("seacatcc.yield(disconnect)", rc);
    }

    public static void reset() throws IOException {
        int rc = seacatcc.yield('r');
        RC.checkAndThrowIOException("seacatcc.yield(reset)", rc);
    }

    public static void renew() throws IOException {
        int rc = seacatcc.yield('n');
        RC.checkAndThrowIOException("seacatcc.yield(renew)", rc);
    }

    public static void setCSRWorker(Runnable csrWorker) {
        SeaCatInternals.setCSRWorker(csrWorker);
    }

    public static void setLogMask(EnumSet<LogFlag> mask) throws IOException {
        Iterator itr = mask.iterator();
        long bitmask = 0L;
        while (itr.hasNext()) {
            LogFlag flag = (LogFlag)((Object)itr.next());
            bitmask |= flag.value;
        }
        int rc = seacatcc.log_set_mask(bitmask);
        RC.checkAndThrowIOException("seacatcc.log_set_mask()", rc);
        SeaCatInternals.logDebug = mask.contains((Object)LogFlag.DEBUG_GENERIC);
    }

    public static void configureSocket(int port, SocketConfig.Domain domain, SocketConfig.Type type, int protocol, String peerAddress, String peerPort) throws IOException {
        int rc = seacatcc.socket_configure_worker(port, domain.getValue(), type.getValue(), protocol, peerAddress, peerPort);
        RC.checkAndThrowIOException("seacatcc.socket_configure_worker()", rc);
    }

    public static void setPackageName(String packageName) {
        Reactor.setPackageName(packageName);
    }

    public static String getClientId() {
        Reactor r = SeaCatClient.getReactor();
        if (r == null) {
            return null;
        }
        return r.getClientId();
    }

    public static String getClientTag() {
        Reactor r = SeaCatClient.getReactor();
        if (r == null) {
            return null;
        }
        return r.getClientTag();
    }

    private SeaCatClient() {
    }

    public static enum LogFlag {
        DEBUG_GENERIC(1L);

        public static final EnumSet<LogFlag> ALL_SET;
        public static final EnumSet<LogFlag> NONE_SET;
        private final long value;

        private LogFlag(long v) {
            this.value = v;
        }

        static {
            ALL_SET = EnumSet.allOf(LogFlag.class);
            NONE_SET = EnumSet.noneOf(LogFlag.class);
        }
    }
}

