/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.cvio;

import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import com.teskalabs.cvio.cviojni;

class VNCServer
extends ContextWrapper {
    private static final String TAG = VNCServer.class.getName();
    private Thread mVNCThread = null;
    private final String socketFileName = this.getDir("cvio", 0).getAbsolutePath() + "/s/vnc";

    public VNCServer(Context base) {
        super(base);
    }

    public boolean start(final int screenWidth, final int screenHeight) {
        if (screenWidth < 0 || screenHeight < 0) {
            Log.e((String)TAG, (String)"Screen width/height is not specified");
            return false;
        }
        if (this.mVNCThread != null) {
            try {
                this.mVNCThread.join(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.mVNCThread.isAlive()) {
                this.mVNCThread = null;
            }
        }
        if (this.mVNCThread == null) {
            this.mVNCThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)"VNC Server started");
                    int rc = cviojni.run_vnc_server(VNCServer.this.socketFileName, screenWidth, screenHeight);
                    if (rc != 0) {
                        Log.w((String)TAG, (String)("VNC Server thread exited with rc: " + rc));
                    }
                    Log.i((String)TAG, (String)"VNC Server terminated");
                }
            });
            this.mVNCThread.setName("cvioVNCThread");
            this.mVNCThread.setDaemon(true);
            this.mVNCThread.start();
        }
        return true;
    }

    public void stop() {
        if (this.mVNCThread == null) {
            return;
        }
        int rc = cviojni.shutdown_vnc_server();
        if (rc != 0) {
            Log.w((String)TAG, (String)("shutdown_vnc_server returned: " + rc));
        }
        if (this.mVNCThread != null) {
            try {
                this.mVNCThread.join(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mVNCThread = null;
        }
    }

    public String getSocketFileName() {
        return this.socketFileName;
    }
}

