/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.cvio;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import com.teskalabs.cvio.CVIOSeaCatPlugin;
import com.teskalabs.cvio.VNCDelegate;
import com.teskalabs.cvio.VNCServer;
import com.teskalabs.cvio.cviojni;
import com.teskalabs.cvio.inapp.InAppInputManager;
import com.teskalabs.cvio.inapp.KeySym;
import com.teskalabs.seacat.android.client.CSR;
import com.teskalabs.seacat.android.client.SeaCatClient;
import com.teskalabs.seacat.android.client.socket.SocketConfig;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CatVision
extends ContextWrapper
implements VNCDelegate {
    private static final String TAG = CatVision.class.getName();
    public static final String DEFAULT_CLIENT_HANDLE = "-DefaultClientHandle-";
    private static final String PREFS_CLIENT_HANDLE_KEY = "clientHandle";
    private static final String PREFS_NAME = "cvio.prefs";
    protected static CVIOSeaCatPlugin cvioSeaCatPlugin = null;
    private static final int port = 5900;
    private static double downscale = 0.0;
    private MediaProjectionManager mProjectionManager = null;
    private static MediaProjection sMediaProjection = null;
    private static Thread sCaptureThread = null;
    private ImageReader mImageReader = null;
    private Handler mHandler = null;
    private VirtualDisplay mVirtualDisplay = null;
    private static final int VIRTUAL_DISPLAY_FLAGS = 9;
    private int mDensity;
    private Display mDisplay = null;
    private int mRotation;
    private OrientationChangeCallback mOrientationChangeCallback = null;
    private final VNCServer vncServer;
    private final InAppInputManager inputManager;
    private final String APIKeyId;
    private String clientHandle = "-DefaultClientHandle-";
    protected static CatVision instance = null;
    Runnable mPingRun = new Runnable(){

        @Override
        public void run() {
            try {
                SeaCatClient.ping();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"SeaCat ping", (Throwable)e);
            }
            finally {
                CatVision.this.mHandler.postDelayed(CatVision.this.mPingRun, 30000L);
            }
        }
    };

    public static CatVision initialize(Application app) {
        return CatVision.initialize(app, false);
    }

    public static synchronized CatVision initialize(Application app, boolean hasClientHandle) {
        if (instance != null) {
            throw new RuntimeException("Already initialized");
        }
        try {
            instance = new CatVision(app, hasClientHandle);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    public static CatVision getInstance() {
        return instance;
    }

    private CatVision(Application app, boolean hasClientHandle) throws IOException {
        super(app.getApplicationContext());
        this.APIKeyId = CatVision.getMetaData(app.getApplicationContext(), "cvio.api_key_id");
        if (this.APIKeyId == null) {
            throw new RuntimeException("CatVision access key (cvio.api_key_id) not provided");
        }
        if (cvioSeaCatPlugin == null) {
            cvioSeaCatPlugin = new CVIOSeaCatPlugin(5900);
        }
        if (hasClientHandle) {
            this.clientHandle = null;
        }
        SeaCatClient.setPackageName("com.teskalabs.cvio");
        SeaCatClient.initialize(app.getApplicationContext(), new Runnable(){

            @Override
            public void run() {
                CatVision.this.submitCSR();
            }
        });
        cviojni.set_delegate(this);
        this.vncServer = new VNCServer((Context)this);
        this.inputManager = new InAppInputManager(app);
        SeaCatClient.configureSocket(5900, SocketConfig.Domain.AF_UNIX, SocketConfig.Type.SOCK_STREAM, 0, this.vncServer.getSocketFileName(), "");
    }

    synchronized void submitCSR() {
        if (this.clientHandle == null) {
            Log.w((String)TAG, (String)"Client handle is null, cannot submit CSR");
            return;
        }
        String state = SeaCatClient.getState();
        if (state.charAt(1) != 'C') {
            Log.w((String)TAG, (String)"SeaCat is not ready for CSR");
            return;
        }
        CSR csr = new CSR();
        csr.setOrganization(this.getPackageName());
        csr.setOrganizationUnit(this.APIKeyId);
        if (this.clientHandle != DEFAULT_CLIENT_HANDLE) {
            csr.setUniqueIdentifier(this.clientHandle);
        }
        try {
            csr.submit();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Submitting CSR", (Throwable)e);
        }
    }

    public void resetClientHandle() {
        SharedPreferences sharedPref = this.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.remove(PREFS_CLIENT_HANDLE_KEY);
        editor.commit();
        this.clientHandle = null;
        try {
            SeaCatClient.reset();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Client reset", (Throwable)e);
        }
    }

    public void setClientHandle(String clientHandle) {
        this.clientHandle = clientHandle;
        SharedPreferences sharedPref = this.getSharedPreferences(PREFS_NAME, 0);
        if (sharedPref.contains(PREFS_CLIENT_HANDLE_KEY)) {
            if (!sharedPref.getString(PREFS_CLIENT_HANDLE_KEY, "").equals(clientHandle)) {
                SharedPreferences.Editor editor = sharedPref.edit();
                editor.putString(PREFS_CLIENT_HANDLE_KEY, clientHandle);
                editor.commit();
                try {
                    SeaCatClient.reset();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Reset identity", (Throwable)e);
                }
            } else {
                String state = SeaCatClient.getState();
                if (state.charAt(1) == 'C') {
                    this.submitCSR();
                    return;
                }
                Log.w((String)TAG, (String)("SeaCat client state: " + SeaCatClient.getState()));
            }
        } else {
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putString(PREFS_CLIENT_HANDLE_KEY, clientHandle);
            editor.commit();
            this.submitCSR();
        }
    }

    public void requestStart(Activity activity, int requestCode) {
        this.mProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
        if (sCaptureThread == null) {
            sCaptureThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    CatVision.this.mHandler = new Handler();
                    Looper.loop();
                }
            });
            sCaptureThread.start();
        }
        try {
            SeaCatClient.connect();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"SeaCatClient expcetion", (Throwable)e);
        }
        activity.startActivityForResult(this.mProjectionManager.createScreenCaptureIntent(), requestCode);
    }

    public void stop() {
        if (sCaptureThread == null) {
            return;
        }
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sMediaProjection != null) {
                    sMediaProjection.stop();
                }
            }
        });
        this.vncServer.stop();
        this.stopRepeatingPing();
    }

    public boolean isStarted() {
        return sMediaProjection != null;
    }

    public void onActivityResult(Activity activity, int resultCode, Intent data) {
        sMediaProjection = this.mProjectionManager.getMediaProjection(resultCode, data);
        if (sMediaProjection != null) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mDensity = metrics.densityDpi;
            this.mDisplay = activity.getWindowManager().getDefaultDisplay();
            if (downscale == 0.0) {
                downscale = this.mDensity < 150 ? 1.0 : (this.mDensity < 300 ? 2.0 : 4.0);
            }
            this.createVirtualDisplay();
            this.mOrientationChangeCallback = new OrientationChangeCallback((Context)this);
            if (this.mOrientationChangeCallback.canDetectOrientation()) {
                this.mOrientationChangeCallback.enable();
            }
            sMediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), this.mHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeImage() {
        if (this.mImageReader == null) {
            return;
        }
        try (Image image = null;){
            image = this.mImageReader.acquireLatestImage();
            if (image != null) {
                Image.Plane[] planes = image.getPlanes();
                ByteBuffer b = planes[0].getBuffer();
                cviojni.push_pixels(b, planes[0].getRowStride());
            }
        }
    }

    private void createVirtualDisplay() {
        Point size = new Point();
        this.mDisplay.getRealSize(size);
        int mWidth = (int)((double)size.x / downscale);
        int mHeight = (int)((double)size.y / downscale);
        this.vncServer.stop();
        this.vncServer.start(mWidth, mHeight);
        this.startRepeatingPing();
        this.mImageReader = ImageReader.newInstance((int)mWidth, (int)mHeight, (int)1, (int)2);
        this.mVirtualDisplay = sMediaProjection.createVirtualDisplay("cviodisplay", mWidth, mHeight, this.mDensity, 9, this.mImageReader.getSurface(), null, this.mHandler);
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), this.mHandler);
    }

    protected void startRepeatingPing() {
        this.stopRepeatingPing();
        this.mPingRun.run();
    }

    void stopRepeatingPing() {
        this.mHandler.removeCallbacks(this.mPingRun);
    }

    @Override
    public void rfbKbdAddEventProc(boolean down, long keySymCode, String client) {
        KeySym ks = (KeySym)((Object)KeySym.lookup.get((int)keySymCode));
        this.inputManager.onKeyboardEvent(down, ks);
    }

    @Override
    public void rfbKbdReleaseAllKeysProc(String client) {
        Log.d((String)TAG, (String)("rfbKbdReleaseAllKeysProc: client:" + client));
    }

    @Override
    public void rfbPtrAddEventProc(int buttonMask, int x, int y, String client) {
        this.inputManager.onMouseEvent(buttonMask, (int)((double)x * downscale), (int)((double)y * downscale));
    }

    @Override
    public void rfbSetXCutTextProc(String text, String client) {
        Log.d((String)TAG, (String)("rfbSetXCutTextProc: text:" + text + " client:" + client));
    }

    @Override
    public int rfbNewClientHook(String client) {
        Log.i((String)TAG, (String)("New VNC client:" + client));
        return 0;
    }

    public static String getMetaData(Context context, String name) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString(name);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Log.e((String)TAG, (String)("Unable to load meta-data: " + e.getMessage()));
            return null;
        }
    }

    private class OrientationChangeCallback
    extends OrientationEventListener {
        OrientationChangeCallback(Context context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOrientationChanged(int orientation) {
            OrientationChangeCallback orientationChangeCallback = this;
            synchronized (orientationChangeCallback) {
                int rotation = CatVision.this.mDisplay.getRotation();
                if (rotation != CatVision.this.mRotation) {
                    CatVision.this.mRotation = rotation;
                    try {
                        if (CatVision.this.mVirtualDisplay != null) {
                            CatVision.this.mVirtualDisplay.release();
                        }
                        if (CatVision.this.mImageReader != null) {
                            CatVision.this.mImageReader.setOnImageAvailableListener(null, null);
                        }
                        CatVision.this.createVirtualDisplay();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            CatVision.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (CatVision.this.mVirtualDisplay != null) {
                        CatVision.this.mVirtualDisplay.release();
                    }
                    if (CatVision.this.mImageReader != null) {
                        CatVision.this.mImageReader.setOnImageAvailableListener(null, null);
                    }
                    if (CatVision.this.mOrientationChangeCallback != null) {
                        CatVision.this.mOrientationChangeCallback.disable();
                    }
                    sMediaProjection.unregisterCallback((MediaProjection.Callback)MediaProjectionStopCallback.this);
                    sMediaProjection = null;
                    CatVision.this.vncServer.stop();
                    CatVision.this.stopRepeatingPing();
                }
            });
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        public void onImageAvailable(ImageReader reader) {
            cviojni.image_ready();
        }
    }
}

