/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.keychain.crypto;

import com.terracotta.management.keychain.crypto.EnigmaMachine;
import com.terracotta.management.keychain.crypto.SecretMismatchException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEnigmaMachine
implements EnigmaMachine {
    private static final byte[] iv = new byte[]{95, 95, 116, 99, 95, 100, 115, 111, 82, 117, 108, 101, 122, 40, 41, 86};
    private final int iterations;

    public AesEnigmaMachine() {
        this(500);
    }

    public AesEnigmaMachine(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public byte[] encrypt(byte[] key, byte[] decrypted) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(this.getMD5(key), "AES"), new IvParameterSpec(iv));
            byte[] bytes = decrypted;
            for (int i = 0; i < this.iterations; ++i) {
                bytes = cipher.doFinal(bytes);
            }
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't encrypt things", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] key, byte[] crypted) {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(this.getMD5(key), "AES"), new IvParameterSpec(iv));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't decrypt things", e);
        }
        try {
            byte[] bytes = crypted;
            for (int i = 0; i < this.iterations; ++i) {
                bytes = cipher.doFinal(bytes);
            }
            return bytes;
        }
        catch (IllegalBlockSizeException e) {
            throw new SecretMismatchException(e);
        }
        catch (BadPaddingException e) {
            throw new SecretMismatchException(e);
        }
    }

    private byte[] getMD5(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't calculate MD5 for " + new String(input), e);
        }
    }
}

