/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.shiro.realm.LdapRealm;
import com.terracotta.management.security.shiro.realm.TCJndiLdapContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryRealm
extends LdapRealm {
    private static final Logger log = LoggerFactory.getLogger(ActiveDirectoryRealm.class);
    private static String DEFAULT_SEARCH_FILTER_ATTR = "CN";
    private static String DEFAULT_SEARCH_FILTER_PATTERN = "(&(objectClass=user)(objectCategory=person)(%s={0}))";
    private String searchFilter;

    @Override
    public Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        if (username.contains("\\")) {
            username = username.substring(username.indexOf("\\") + 1);
        }
        Object[] searchArguments = new Object[]{username};
        String filter = this.searchFilter;
        if (filter == null) {
            String filterAttr = this.getUserDnPrefix();
            if (filterAttr == null) {
                filterAttr = DEFAULT_SEARCH_FILTER_ATTR;
            }
            filter = String.format(DEFAULT_SEARCH_FILTER_PATTERN, filterAttr);
        }
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, filter, searchArguments, searchCtls);
        while (answer.hasMoreElements()) {
            Attributes attrs;
            SearchResult sr = answer.next();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving group names for user [" + sr.getName() + "]");
            }
            if ((attrs = sr.getAttributes()) == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().equals("memberOf")) continue;
                Collection groupNames = LdapUtils.getAllAttributeValues((Attribute)attr);
                if (log.isDebugEnabled()) {
                    log.debug("Groups found for user [" + username + "]: " + groupNames);
                }
                Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                roleNames.addAll(rolesForGroups);
            }
        }
        this.fixRoleNamesForTMS(roleNames);
        if (log.isDebugEnabled()) {
            log.debug("Role Names for user [{}]: {}", (Object)username, roleNames);
        }
        return roleNames;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    @Override
    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> allAdGroups = new HashSet<String>();
        for (String groupName : groupNames) {
            allAdGroups.addAll(this.processGroup(groupName));
        }
        if (log.isDebugEnabled()) {
            log.debug("Group names for user: {}", allAdGroups);
        }
        return this.translateGroups(allAdGroups);
    }

    private Collection<String> processGroup(String groupDN) {
        try {
            LdapName groupName = new LdapName(groupDN);
            LdapName searchBaseName = new LdapName(this.searchBase);
            if (groupName.startsWith(searchBaseName)) {
                HashSet<String> groups = new HashSet<String>();
                ArrayList<Rdn> rdns = new ArrayList<Rdn>(groupName.getRdns());
                Collections.reverse(rdns);
                int groupCNSearchLength = rdns.size() - searchBaseName.size();
                for (int i = 0; i < groupCNSearchLength; ++i) {
                    Rdn rdn = (Rdn)rdns.get(i);
                    if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                    groups.add(rdn.getValue().toString());
                }
                return groups;
            }
            log.info("Ignoring group {} because it doesn't exist in searchBase", (Object)groupDN);
        }
        catch (InvalidNameException e) {
            log.info("Invalid name", (Throwable)e);
        }
        return Collections.emptySet();
    }

    private Collection<String> translateGroups(Collection<String> allAdGroups) {
        if (this.groupRolesMap != null) {
            HashSet<String> result = new HashSet<String>();
            for (String adGroup : allAdGroups) {
                Set xlatedGroup = (Set)this.groupRolesMap.get(adGroup);
                if (xlatedGroup == null) continue;
                for (String role : xlatedGroup) {
                    result.add(role);
                }
            }
            return result;
        }
        return allAdGroups;
    }

    @Override
    public void setSystemUsername(String systemUsername) {
        String fullSystemUsername = this.getUserDn(systemUsername);
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSystemUsername(fullSystemUsername);
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSimpleSystemUsername(systemUsername);
    }
}

