/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.authc;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class ManagementAuthenticationListener
implements AuthenticationListener {
    private static final String USERNAME = "username";
    private static final String HOST = "host";
    private static final Logger LOG = LoggerFactory.getLogger(ManagementAuthenticationListener.class);

    public void onSuccess(AuthenticationToken authenticationToken, AuthenticationInfo authenticationInfo) {
        MDC.put((String)USERNAME, (String)authenticationToken.getPrincipal().toString());
    }

    public void onFailure(AuthenticationToken authenticationToken, AuthenticationException e) {
        LOG.error("Unable to login " + authenticationToken.getPrincipal(), (Throwable)e);
    }

    public void onLogout(PrincipalCollection principalCollection) {
        MDC.remove((String)USERNAME);
    }
}

