/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.SecretUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.services.Utils;

public final class KeyChainAwareSSLContextFactory
implements SSLContextFactory {
    private static final String JVM_ID_LOCATION_PROP = "javax.net.ssl.keyStore";
    private static final String JVM_ID_PASSWD_PROP = "javax.net.ssl.keyStorePassword";
    private static final String JVM_TRUST_LOCATION_PROP = "javax.net.ssl.trustStore";
    private static final String JVM_TRUST_PASSWD_PROP = "javax.net.ssl.trustStorePassword";
    private static final String SS_PROTOCOL = "TLS";
    private static final String SECURE_RNDM_ALG = "SHA1PRNG";
    private final KeyChainAccessor keyChainAccessor;
    private final String idStoreLocation;
    private final String trustStoreLocation;
    private final boolean usingClientAuth;
    private static final Logger LOG = LoggerFactory.getLogger(KeyChainAwareSSLContextFactory.class);

    public KeyChainAwareSSLContextFactory(KeyChainAccessor keyChainAccessor, boolean usingClientAuth) {
        this(keyChainAccessor, null, null, usingClientAuth);
    }

    public KeyChainAwareSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation) {
        this(keyChainAccessor, dfltIdStoreLocation, dfltTrustStoreLocation, false);
    }

    public KeyChainAwareSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation, boolean usingClientAuth) {
        LOG.info("Initializing the KeyChainAwareSSLContextFactory");
        this.keyChainAccessor = keyChainAccessor;
        this.usingClientAuth = usingClientAuth;
        this.idStoreLocation = this.getKeyStoreLocation(dfltIdStoreLocation);
        this.trustStoreLocation = this.getTrustStoreLocation(dfltTrustStoreLocation);
    }

    KeyChainAwareSSLContextFactory() {
        this.keyChainAccessor = null;
        this.usingClientAuth = false;
        this.idStoreLocation = null;
        this.trustStoreLocation = null;
    }

    String getTrustStoreLocation(String dfltTrustStoreLocation) {
        String trustStoreLocation = System.getProperty(JVM_TRUST_LOCATION_PROP);
        if (trustStoreLocation == null) {
            if (dfltTrustStoreLocation == null) {
                LOG.info("Using JVM default truststore");
                return null;
            }
            trustStoreLocation = dfltTrustStoreLocation;
        }
        if (!new File(trustStoreLocation).isFile()) {
            throw new IllegalArgumentException("Error reading truststore at location : " + trustStoreLocation);
        }
        LOG.info("KeyChainAwareSSLContextFactory truststore location is : {}", (Object)trustStoreLocation);
        System.setProperty(JVM_TRUST_LOCATION_PROP, trustStoreLocation);
        return trustStoreLocation;
    }

    String getKeyStoreLocation(String dfltIdStoreLocation) {
        String keyStoreLocation = System.getProperty(JVM_ID_LOCATION_PROP);
        if (keyStoreLocation == null) {
            if (dfltIdStoreLocation == null) {
                if (this.usingClientAuth) {
                    throw new IllegalArgumentException("Keystore location cannot be null if clientAuth is enabled (2 ways ssl)");
                }
                LOG.info("Using JVM default keystore");
                return null;
            }
            keyStoreLocation = dfltIdStoreLocation;
        }
        if (!new File(keyStoreLocation).isFile()) {
            if (this.usingClientAuth) {
                throw new IllegalArgumentException("Keystore location cannot be null if clientAuth is enabled (2 ways ssl)");
            }
            LOG.info("Error reading keystore at location " + keyStoreLocation + ", using JVM default one");
            return null;
        }
        LOG.info("KeyChainAwareSSLContextFactory keystore location is : {}", (Object)this.idStoreLocation);
        return keyStoreLocation;
    }

    @Override
    public SSLContext create() throws NoSuchAlgorithmException, IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        KeyManagerFactory kmf = this.prepareKeyManagerFactory();
        TrustManagerFactory tmf = this.prepareTrustManagerFactory();
        TrustManager[] trustManagers = Boolean.getBoolean("tc.ssl.trustAllCerts") ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }} : (tmf == null ? null : tmf.getTrustManagers());
        SSLContext sslCtxt = SSLContext.getInstance(SS_PROTOCOL);
        sslCtxt.init(kmf == null ? null : kmf.getKeyManagers(), trustManagers, SecureRandom.getInstance(SECURE_RNDM_ALG));
        return sslCtxt;
    }

    @Override
    public boolean isUsingClientAuth() {
        return this.usingClientAuth;
    }

    private KeyManagerFactory prepareKeyManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        File idStoreFile;
        KeyManagerFactory kmf = null;
        if (this.idStoreLocation != null && (idStoreFile = new File(this.idStoreLocation)).exists()) {
            char[] idStorePasswd = this.locateKeyStorePassword(JVM_ID_PASSWD_PROP, this.idStoreLocation);
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
            identityStore.load(new FileInputStream(idStoreFile), idStorePasswd);
            kmf.init(identityStore, idStorePasswd);
        }
        return kmf;
    }

    private TrustManagerFactory prepareTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        File trustStoreFile;
        TrustManagerFactory tmf = null;
        if (this.trustStoreLocation != null && (trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            char[] trustStorePasswd = this.locateKeyStorePassword(JVM_TRUST_PASSWD_PROP, this.trustStoreLocation);
            System.setProperty(JVM_TRUST_PASSWD_PROP, new String(trustStorePasswd));
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(new FileInputStream(trustStoreFile), trustStorePasswd);
            tmf.init(trustStore);
        }
        return tmf;
    }

    private char[] locateKeyStorePassword(String jvmPasswordProp, String keyStoreLocation) {
        char[] passwd;
        String jvmStorePasswd = System.getProperty(jvmPasswordProp);
        if (Utils.trimToNull((String)jvmStorePasswd) == null) {
            URI idStoreURI = new File(keyStoreLocation).toURI();
            URIKeyName kname = new URIKeyName(idStoreURI);
            byte[] secret = this.keyChainAccessor.retrieveSecret((KeyName)kname);
            if (secret == null) {
                throw new RuntimeException(String.format("Failure creating SSLContext because the store password could not be located for %s.", kname));
            }
            passwd = SecretUtils.toCharsAndWipe((byte[])secret);
        } else {
            passwd = jvmStorePasswd.toCharArray();
        }
        return passwd;
    }

    public String toString() {
        String idStore = this.idStoreLocation == null ? "<default>" : this.idStoreLocation;
        String trustStore = this.trustStoreLocation == null ? "<default>" : this.trustStoreLocation;
        return "keystore @ " + idStore + ", truststore @ " + trustStore;
    }
}

