/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shiro.codec.Base64;

public final class HMACBuilder {
    private static final String DFLT_ALG = "HmacSHA1";
    private static final byte FILLER_BYTE = 0;
    private final byte[] keyMaterial;
    private final String algorithm;
    private List<String> messageComponents;
    private UserInfo user;

    private HMACBuilder(byte[] keyMaterial, String algorithm) {
        if (keyMaterial == null) {
            throw new IllegalArgumentException("keyMaterial == null");
        }
        this.keyMaterial = keyMaterial;
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm == null");
        }
        this.algorithm = algorithm;
    }

    public static HMACBuilder getInstance(byte[] keyMaterial) {
        return new HMACBuilder(keyMaterial, DFLT_ALG);
    }

    public static HMACBuilder getInstance(byte[] keyMaterial, String algorithm) {
        return new HMACBuilder(keyMaterial, algorithm);
    }

    public HMACBuilder addMessageComponent(String messageComponent) {
        if (this.messageComponents == null) {
            this.messageComponents = new ArrayList<String>();
        }
        this.messageComponents.add(messageComponent);
        return this;
    }

    public HMACBuilder addUserDetail(UserInfo user) {
        this.user = user;
        return this;
    }

    public byte[] build() throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKey = new SecretKeySpec(this.keyMaterial, this.algorithm);
        Mac mac = Mac.getInstance(this.algorithm);
        mac.init(secretKey);
        if (this.messageComponents == null) {
            throw new IllegalStateException("No message components available to hash.");
        }
        StringBuilder message = new StringBuilder();
        for (String mc : this.messageComponents) {
            message.append(mc);
            message.append(mc.length());
        }
        if (this.user != null) {
            message.append(this.user.getUsername());
            message.append(this.user.getUsername().length());
            TreeSet sortedRoles = new TreeSet(this.user.getRoles());
            for (UserRole r : sortedRoles) {
                message.append(r.toString());
                message.append(r.toString().length());
            }
        }
        byte[] hmac = mac.doFinal(message.toString().getBytes());
        Arrays.fill(this.keyMaterial, (byte)0);
        return hmac;
    }

    public String buildEncoded() throws NoSuchAlgorithmException, InvalidKeyException {
        return Base64.encodeToString((byte[])this.build());
    }
}

