/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.client;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class ClientArray
implements java.sql.Array {
    private Object[] m_aoElements;
    private String m_sBaseTypeName;
    private int m_nBaseType = 0;
    private boolean m_bArrayFreed = false;
    private int m_nDimensions;
    private TDSession m_session;

    public ClientArray(TDSession tDSession, String string, Object[] objectArray) throws SQLException {
        if (tDSession.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (!tDSession.isArrayDataTypeSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ174", tDSession.getTeradataDatabaseVersion());
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ644");
        }
        if (objectArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ748");
        }
        this.m_session = tDSession;
        this.m_sBaseTypeName = string;
        this.m_nDimensions = ClientArray.calculateArrayDimensions(objectArray);
        this.m_aoElements = ClientArray.copyElements(objectArray, this.m_nDimensions);
    }

    public void free() throws SQLException {
        if (this.m_bArrayFreed) {
            return;
        }
        this.m_aoElements = new Object[0];
        this.m_bArrayFreed = true;
    }

    public String getBaseTypeName() throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return this.m_sBaseTypeName;
    }

    public int getBaseType() throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return this.m_nBaseType;
    }

    public Object getArray() throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return ClientArray.copyElements(this.m_aoElements, this.m_nDimensions);
    }

    public Object getArray(long l, int n) throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        if (this.m_nDimensions > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ749");
        }
        if (l < 1L || l > (long)(this.m_aoElements.length + 1)) {
            throw ErrorFactory.makeDriverJDBCException("TJ747", String.valueOf(l), String.valueOf(this.m_aoElements.length + 1));
        }
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ752", n);
        }
        int n2 = (int)(l - 1L);
        int n3 = this.m_aoElements.length - n2;
        n = Math.min(n, n3);
        Object[] objectArray = new Object[n];
        System.arraycopy(this.m_aoElements, n2, objectArray, 0, n);
        return objectArray;
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        return this.getArray(l, n);
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, this.m_aoElements.length, (Map)null);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, (Map)null);
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        if (this.m_nDimensions > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ749");
        }
        if (l < 1L || l > (long)(this.m_aoElements.length + 1)) {
            throw ErrorFactory.makeDriverJDBCException("TJ747", String.valueOf(l), String.valueOf(this.m_aoElements.length + 1));
        }
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ752", n);
        }
        TeraResultSetMetaData teraResultSetMetaData = this.m_session.constructResultSetMetaData();
        teraResultSetMetaData.addColumnProperties(this.getIndexColumnProperties(), true);
        teraResultSetMetaData.addColumnProperties(this.getElementColumnProperties(), true);
        TDResultSet tDResultSet = this.m_session.constructResultSet(teraResultSetMetaData, 1, null, null, this.m_session.getLog());
        tDResultSet.setActivityCount(this.m_aoElements.length);
        for (int i = (int)l; (long)i <= l + (long)n && i <= this.m_aoElements.length; ++i) {
            ResultSetRow resultSetRow = new ResultSetRow();
            resultSetRow.addValue(new Integer(i));
            resultSetRow.addValue(this.m_aoElements[i - 1]);
            tDResultSet.addResultSetRow(resultSetRow);
        }
        return (ResultSet)((Object)tDResultSet);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return this.getResultSet(1L, this.m_aoElements.length, map);
    }

    private static Object[] copyElements(Object[] objectArray, int n) {
        if (n == 1) {
            Object[] objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            return objectArray2;
        }
        int[] nArray = new int[n];
        nArray[0] = objectArray.length;
        Object[][] objectArray3 = (Object[][])Array.newInstance(Object.class, nArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray3[i] = ClientArray.copyElements((Object[])objectArray[i], n - 1);
        }
        return objectArray3;
    }

    private ColumnProperties getIndexColumnProperties() {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setPrecision(10);
        columnProperties.setScale(0);
        columnProperties.setNullable(1);
        columnProperties.setColumnType(4, 497);
        columnProperties.setTdType(497);
        columnProperties.setColumnDisplaySize(JDBC4Constants.getDisplaySize(496));
        columnProperties.setReadOnly(true);
        columnProperties.setIsSigned(true);
        return columnProperties;
    }

    private ColumnProperties getElementColumnProperties() {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setPrecision(0);
        columnProperties.setScale(0);
        columnProperties.setNullable(1);
        columnProperties.setColumnType(this.m_nBaseType, -1);
        columnProperties.setColumnDisplaySize(0);
        columnProperties.setReadOnly(true);
        columnProperties.setIsSigned(true);
        return columnProperties;
    }

    public static int calculateArrayDimensions(Object[] objectArray) {
        int n = 0;
        for (Class<?> clazz = objectArray.getClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n;
        }
        return n;
    }

    public static int determineBaseType(int n, Object[] objectArray, int n2, boolean bl) throws SQLException {
        int n3 = ClientArray.getArrayBaseSqlType(objectArray, n2, n);
        if (n3 != 0) {
            return n3;
        }
        if (bl) {
            return 12;
        }
        if (n2 == -2) {
            return -3;
        }
        return n2;
    }

    private static int getArrayBaseSqlType(Object[] objectArray, int n, int n2) throws SQLException {
        int n3 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (n2 > 1) {
                n3 = ClientArray.getArrayBaseSqlType((Object[])objectArray[i], n, n2 - 1);
            } else if (objectArray[i] instanceof Date) {
                n3 = 91;
            } else if (objectArray[i] instanceof String) {
                n3 = 12;
            } else if (objectArray[i] instanceof Short) {
                n3 = 5;
            } else if (objectArray[i] instanceof Long) {
                n3 = -5;
            } else if (objectArray[i] instanceof Integer) {
                n3 = 4;
            } else if (objectArray[i] instanceof Byte) {
                n3 = -6;
            } else if (objectArray[i] instanceof BigDecimal) {
                n3 = 2;
            } else if (objectArray[i] instanceof Boolean) {
                n3 = 16;
            } else if (objectArray[i] instanceof Time) {
                n3 = 92;
            } else if (objectArray[i] instanceof Timestamp) {
                n3 = 93;
            } else if (objectArray[i] instanceof Float) {
                n3 = 6;
            } else if (objectArray[i] instanceof Double) {
                n3 = 8;
            } else if (objectArray[i] instanceof byte[]) {
                n3 = -3;
            } else if (objectArray[i] instanceof SQLData && n != 2002) {
                n3 = 2001;
            } else if (objectArray[i] instanceof Struct || objectArray[i] instanceof SQLData) {
                n3 = 2002;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ751", objectArray[i].getClass().getName());
            }
            if (n3 != 0) break;
        }
        return n3;
    }

    public static int calculateTotNumOfElements(Object[] objectArray, int n) {
        int n2 = 0;
        if (n == 1) {
            return objectArray == null ? 0 : objectArray.length;
        }
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (n <= 1) continue;
            n2 += ClientArray.calculateTotNumOfElements((Object[])objectArray[i], n - 1);
        }
        return n2;
    }

    private static String deepToString(Object[] objectArray) {
        String string = "[";
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Object[])) {
                return Arrays.asList(objectArray).toString();
            }
            string = string + (i > 0 ? ", " : "") + ClientArray.deepToString((Object[])objectArray[i]);
        }
        return string + "]";
    }

    public String toString() {
        return "ClientArray:" + this.m_sBaseTypeName + ClientArray.deepToString(this.m_aoElements);
    }
}

