/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;

public class ResultStruct
implements Struct {
    private String m_sSqlTypeName;
    private Object[] m_aoAttributeValues = new Object[0];
    private Object[] m_aoMappedAttributeValues = new Object[0];
    private int[] m_anAttributeSqlTypes;
    private String[] m_asAttributeTypeNames;
    private int[] m_anAttributeBaseJDBCTypes;
    private ResultSetHelper m_helper;

    public void initStruct(int n, String string, ResultSetHelper resultSetHelper) {
        this.m_aoAttributeValues = new Object[n];
        this.m_sSqlTypeName = string;
        this.m_anAttributeSqlTypes = new int[n];
        this.m_asAttributeTypeNames = new String[n];
        this.m_anAttributeBaseJDBCTypes = new int[n];
        this.m_helper = resultSetHelper;
    }

    private ResultStruct copyStruct(Map map) throws SQLException {
        ResultStruct resultStruct = new ResultStruct();
        resultStruct.initStruct(this.m_aoAttributeValues.length, this.m_sSqlTypeName, this.m_helper);
        resultStruct.m_aoAttributeValues = ResultStruct.copyArray(this.m_aoAttributeValues);
        resultStruct.m_aoMappedAttributeValues = this.getAttributes(map);
        for (int i = 0; i < this.m_aoAttributeValues.length; ++i) {
            resultStruct.m_anAttributeBaseJDBCTypes[i] = this.m_anAttributeBaseJDBCTypes[i];
            resultStruct.m_anAttributeSqlTypes[i] = this.m_anAttributeSqlTypes[i];
            resultStruct.m_asAttributeTypeNames[i] = this.m_asAttributeTypeNames[i];
        }
        return resultStruct;
    }

    public String getSQLTypeName() throws SQLException {
        return this.m_sSqlTypeName;
    }

    public void setSQLTypeName(String string) {
        this.m_sSqlTypeName = string;
    }

    public Object[] getAttributes() throws SQLException {
        return this.internalGetAttributes(this.m_helper.getTypeMap());
    }

    public Object[] getAttributes(Map map) throws SQLException {
        map = TDSession.copyAndVerifyTypeMap(map);
        return this.internalGetAttributes(map);
    }

    private static Object[] copyArray(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public Object[] getMutableMappedAttributeValueArray() {
        this.m_aoMappedAttributeValues = ResultStruct.copyArray(this.m_aoAttributeValues);
        return this.m_aoMappedAttributeValues;
    }

    public int[] getMutableAttributeSQLTypeArray() {
        return this.m_anAttributeSqlTypes;
    }

    public int[] getMutableAttributeBaseJDBCTypeArray() {
        return this.m_anAttributeBaseJDBCTypes;
    }

    public String[] getMutableAttributeTypeNameArray() {
        return this.m_asAttributeTypeNames;
    }

    public Object[] getMutableAttributeValueArray() {
        return this.m_aoAttributeValues;
    }

    private Object[] internalGetAttributes(Map map) throws SQLException {
        Object[] objectArray = ResultStruct.copyArray(this.m_aoAttributeValues);
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            Class clazz = (Class)map.get(this.m_asAttributeTypeNames[i]);
            boolean bl2 = bl = this.m_anAttributeSqlTypes[i] == 2002;
            if (clazz != null && objectArray[i] != null) {
                String[] stringArray;
                int[] nArray;
                int[] nArray2;
                Object[] objectArray2;
                if (bl) {
                    objectArray2 = ((ResultStruct)objectArray[i]).getMutableAttributeValueArray();
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray2 = objectArray3;
                    objectArray3[0] = objectArray[i];
                }
                if (bl) {
                    nArray2 = ((ResultStruct)objectArray[i]).getMutableAttributeSQLTypeArray();
                } else {
                    int[] nArray3 = new int[1];
                    nArray2 = nArray3;
                    nArray3[0] = this.m_anAttributeSqlTypes[i];
                }
                if (bl) {
                    nArray = ((ResultStruct)objectArray[i]).getMutableAttributeBaseJDBCTypeArray();
                } else {
                    int[] nArray4 = new int[1];
                    nArray = nArray4;
                    nArray4[0] = this.m_anAttributeBaseJDBCTypes[i];
                }
                if (bl) {
                    stringArray = ((ResultStruct)objectArray[i]).getMutableAttributeTypeNameArray();
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.m_asAttributeTypeNames[i];
                }
                objectArray[i] = ResultStruct.getSQLData(this.m_helper, clazz, objectArray2, nArray2, nArray, stringArray, this.m_asAttributeTypeNames[i], map);
                continue;
            }
            objectArray[i] = bl && objectArray[i] != null ? ((ResultStruct)objectArray[i]).copyStruct(map) : TDResultSet.internalGetObject(this.m_helper, i + 1, this.m_aoAttributeValues[i], this.m_anAttributeSqlTypes[i], this.m_anAttributeBaseJDBCTypes[i], this.m_asAttributeTypeNames[i], map);
        }
        return objectArray;
    }

    private static SQLException wrapException(Exception exception, Class clazz, String string) {
        SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ688", clazz.getName(), string, exception.toString());
        sQLException.initCause(exception);
        return sQLException;
    }

    public static SQLData getSQLData(ResultSetHelper resultSetHelper, Class clazz, Object[] objectArray, int[] nArray, int[] nArray2, String[] stringArray, String string, Map map) throws SQLException {
        SQLData sQLData;
        SQLInput sQLInput = resultSetHelper.constructSQLInput(objectArray, nArray, nArray2, stringArray, map, clazz);
        try {
            sQLData = (SQLData)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ResultStruct.wrapException(illegalAccessException, clazz, string);
        }
        catch (InstantiationException instantiationException) {
            throw ResultStruct.wrapException(instantiationException, clazz, string);
        }
        sQLData.readSQL(sQLInput, string);
        return sQLData;
    }

    public String toString() {
        return "ResultStruct:" + this.m_sSqlTypeName + Arrays.asList(this.m_aoMappedAttributeValues);
    }
}

