/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1BfEcb;
import com.teradata.tdgss.jgssp2td1.Td1Credential;
import com.teradata.tdgss.jgssp2td1.Td1DH;
import com.teradata.tdgss.jgssp2td1.Td1Mechanism;
import com.teradata.tdgss.jgssp2td1.Td1MinorStatus;
import com.teradata.tdgss.jgssp2td1.Td1Name;
import com.teradata.tdgss.jgssp2td1.Td1Pkey;
import com.teradata.tdgss.jgssp2td1.Td1Version;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class Td1Context
implements GSSContext {
    private final TdgssLogger logger;
    private static final short maxshort = Short.MAX_VALUE;
    private int msgsequence = 0;
    private byte server_client = 1;
    private byte contextInit = 0;
    private TdgssVersion mylibraryversion;
    private Td1Version mymethodversion;
    private byte myendien = 1;
    private byte myencryptionmode = (byte)-1;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] Key = null;
    private boolean newDHkey = false;
    private int BFKEYBYTES = 52;
    private byte[] bfKey = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    static final int MAXMSGSEQUENCESERVER = 2;
    static final int MAXMSGSEQUENCECLIENT = 3;
    static final int LIB_MAJOR_REL_VER_INDEX = 0;
    static final int LIB_MINOR_REL_VER_INDEX = 1;
    static final int LIB_MAINT_REL_VER_INDEX = 2;
    static final int LIB_EMG_REL_VER_INDEX = 3;
    static final int METHOD_MAJOR_REL_VER_INDEX = 4;
    static final int METHOD_MINOR_REL_VER_INDEX = 5;
    static final int METHOD_MAINT_REL_VER_INDEX = 6;
    static final int METHOD_EMG_REL_VER_INDEX = 7;
    static final int ENDIENINDEX = 8;
    static final int ENCRYPTIONMODEINDEX = 9;
    private static final int ENCRYPTIONTYPEINDEX = 10;
    private static final int DHINDEX = 12;
    static final byte TDGSS_BIGENDIEN = 1;
    static final byte TDGSS_SMALLENDIEN = 0;
    static final byte TDGSS_CLIENT = 0;
    static final byte TDGSS_SERVER = 1;
    static final byte TDGSS_ECB = 0;
    static final int TDGSS_SHARED_G = 4068;
    static final int TDGSS_SHARED_N = 7919;
    private byte[] TDGSS_SHARED_N_NEW = null;
    private byte[] TDGSS_SHARED_G_NEW = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int BITSPERBYTE = 8;
    static final int BYTESININT = 4;
    private int MAXKEYBYTES = 56;
    static final int MAX_EXPONENTIAL = Short.MAX_VALUE;
    private int CURRENTKEYBYTES = 52;
    private int keysize = this.CURRENTKEYBYTES / 4 * 4;
    static final String[] msgexttxt = new String[]{"client", "server"};
    private short state;
    private boolean initiator;
    private Td1Credential credential;
    private Td1Name targetName;
    private int lifetime;
    private short requestedServices;
    private Td1DH DH;
    private Td1BfEcb blf;

    public Td1Context(Td1Credential td1Credential, Object[] objectArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.initiator = false;
        this.credential = td1Credential;
        this.initialiseData();
        this.requestedServices = (short)98;
    }

    public Td1Context(Td1Credential td1Credential, Td1Name td1Name, int n, Object[] objectArray, short s, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.initiator = true;
        this.credential = td1Credential;
        this.targetName = td1Name;
        this.lifetime = n;
        this.requestedServices = s;
        this.initialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Td1Version InquireMethodVersion() {
        Td1Version td1Version = new Td1Version();
        return td1Version;
    }

    private void initialiseData() {
        this.msgsequence = 0;
        this.mylibraryversion = Td1Context.InquireLibraryVersion();
        this.mymethodversion = Td1Context.InquireMethodVersion();
        this.myendien = 1;
        this.myencryptionmode = 0;
        this.mycbmaxtoken = 64;
        this.DH = new Td1DH(this.keysize, 4068, 7919, this.logger);
        this.blf = new Td1BfEcb(this.logger);
    }

    private byte[] buildinitmsg() {
        byte[] byArray = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("First time entering - We will initiate the handshake now...");
        }
        byArray = new byte[this.mycbmaxtoken];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byArray[0] = this.mylibraryversion.MajorRelease;
        byArray[1] = this.mylibraryversion.MinorRelease;
        byArray[2] = this.mylibraryversion.MaintenanceRelease;
        byArray[3] = this.mylibraryversion.EmergencyRelease;
        byArray[4] = this.mymethodversion.MajorRelease;
        byArray[5] = this.mymethodversion.MinorRelease;
        byArray[6] = this.mymethodversion.MaintenanceRelease;
        byArray[7] = this.mymethodversion.EmergencyRelease;
        byArray[8] = this.myendien;
        byArray[9] = this.myencryptionmode;
        byArray[10] = 1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Successfully generate first message as", byArray));
        }
        return byArray;
    }

    private void processinitmsg(byte[] byArray, int n) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving and processingfirst message, length = " + n);
            this.logger.debug(TdgssUtil.dump("incoming buffer is ", byArray));
        }
        if (this.server_client == 0) {
            if (byArray[10] == 1) {
                if (n != 16) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("*** ILLEGAL INPUT LENGTH  EXPECTING 16 RECEVING " + n);
                    }
                    throw new TdgssException(11, Td1MinorStatus.TD1_ERR_BUFFER_LEN_MISMATCH);
                }
            } else if (n != this.mycbmaxtoken) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("*** ILLEGAL INPUT LENGTH  EXPECTING " + this.mycbmaxtoken + " RECEVING " + n);
                }
                throw new TdgssException(11, Td1MinorStatus.TD1_ERR_BUFFER_LEN_MISMATCH);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Length is good...");
        }
        this.mytargetendien = byArray[8];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking target endien as " + this.mytargetendien);
        }
        if (this.mytargetendien != 1 && this.mytargetendien != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("*** ILLEGAL PEER ENDIEN! ****");
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_UNKNOWN_ENDIEN);
        }
        if (this.byteflipneeded() && this.logger.isDebugEnabled()) {
            this.logger.debug("WE HAVE TO BYTE-FLIP!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("*** ILLEGAL LIBRARY VERSION ");
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_VERSION_MISMATCH);
        }
        this.chkmethod(byArray);
        if (this.myencryptionmode != byArray[9]) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" OR ENCRYPTION MODE ");
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ENC_MODE_MISMATCH);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Library version and encryption mode are good!");
        }
    }

    public void setkey(byte[] byArray) {
        this.Key = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        if (this.mytargetendien != this.myendien) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            }
            try {
                if (this.isserver()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are server! No need to byte-flip!");
                    }
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are CLIENT, WE HAVE TO BYTE-FLIP!");
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage());
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        if (!this.byteflipneeded()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No flipping needed!");
            }
            return byArray;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Data before byte-flip!", byArray));
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Data after byte-flip!", byArray));
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[0] >= 5;
    }

    private int ByteAtoInt(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.intValue();
    }

    private void chkmethod(byte[] byArray) throws GSSException {
        byte[] byArray2 = new byte[4];
        if (byArray[10] == 1) {
            this.newDHkey = true;
            this.MAXKEYBYTES = 128;
            this.CURRENTKEYBYTES = 80;
            this.keysize = this.CURRENTKEYBYTES / 4 * 4;
            this.BFKEYBYTES = 16;
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("pindex =" + this.ByteAtoInt(byArray2));
            }
            this.TDGSS_SHARED_N_NEW = Td1Pkey.getPkey(this.ByteAtoInt(byArray2));
            if (this.TDGSS_SHARED_N_NEW == null) {
                throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ILLEGAL_SEQUENCE);
            }
            this.DH = new Td1DH(this.keysize, this.TDGSS_SHARED_G_NEW, this.TDGSS_SHARED_N_NEW, 2, this.logger);
        }
        this.bfKey = new byte[this.BFKEYBYTES];
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        byte[] byArray2 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("msgsequence is now " + this.msgsequence);
        }
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Confirming that we are now " + msgexttxt[this.server_client]);
                }
                byArray2 = this.buildinitmsg();
                break;
            }
            case 1: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("len = " + byArray.length + "Just receive info-data from server as:", byArray));
                }
                this.processinitmsg(byArray, n2);
                byArray2 = this.DH.genseed();
                if (byArray2 == null || byArray2.length != this.keysize) {
                    throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_KEY);
                }
                if (!this.newDHkey) {
                    this.msgcvt(byArray2);
                }
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(TdgssUtil.dump("Successfully produce seed-generator as ", byArray2));
                break;
            }
            case 2: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Just received seed-generator from server as:", byArray));
                }
                if (byArray.length != this.keysize) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("*** ERROR! ILLEGAL LENGTH " + byArray.length + " EXPECTING " + this.keysize);
                    }
                    throw new TdgssException(11, Td1MinorStatus.TD1_ERR_BUFFER_LEN_MISMATCH);
                }
                if (!this.newDHkey) {
                    this.msgcvt(byArray);
                }
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("Client is now satisfied - No more message!");
                break;
            }
            default: {
                throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ILLEGAL_SEQUENCE);
            }
        }
        ++this.msgsequence;
        if (this.isEstablished()) {
            this.Key = this.DH.compute_key(byArray);
            System.arraycopy(this.Key, 0, this.bfKey, 0, this.BFKEYBYTES);
            if (!this.newDHkey) {
                this.msgcvt(this.bfKey);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving after incrementing msgsequence to " + this.msgsequence);
        }
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Just receive info-data from client as:", byArray));
                }
                this.processinitmsg(byArray, n2);
                byArray2 = this.buildinitmsg();
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(TdgssUtil.dump("Successfully produce info-data as ", byArray2));
                break;
            }
            case 1: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Just receive seed-generator from client as:", byArray));
                }
                if (byArray.length != this.keysize) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("*** ERROR! ILLEGAL LENGTH " + byArray.length + " EXPECTING " + this.keysize);
                    }
                    throw new TdgssException(11, Td1MinorStatus.TD1_ERR_BUFFER_LEN_MISMATCH);
                }
                byArray2 = this.DH.genseed();
                if (byArray2 == null || byArray2.length != this.keysize) {
                    throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_KEY);
                }
                this.msgcvt(byArray2);
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(TdgssUtil.dump("Successfully produce seed-generator as ", byArray2));
                this.logger.debug("Server satisfied now - No more message!");
                break;
            }
            default: {
                throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ILLEGAL_SEQUENCE);
            }
        }
        ++this.msgsequence;
        if (this.isEstablished()) {
            this.Key = this.DH.compute_key(byArray);
            System.arraycopy(this.Key, 0, this.bfKey, 0, this.BFKEYBYTES);
            this.msgcvt(this.bfKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving after incrementing msgsequence to " + this.msgsequence);
        }
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public int compute_enc_size(int n) {
        int n2 = n & 7;
        int n3 = n;
        if (n2 != 0) {
            n3 = (n & 0xFFFFFFF8) + 8;
        }
        return n3;
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        try {
            n = this.isserver() ? 2 : 3;
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving with retcode = " + bl);
        }
        return bl;
    }

    public boolean isserver() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new TdgssException(11, Td1MinorStatus.TD1_ERR_BAD_CONTEXT_STATE);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (n2 < 4) {
            return 0;
        }
        int n3 = n2 - 4;
        int n4 = n3 % 8;
        if (n4 != 0) {
            n3 -= n4;
        }
        return n3;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = n2;
        int n4 = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ONLY OFFSET = 0 IS ALLOWED!");
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_OFFSET_NOT_ZERO);
        }
        if (n2 > byArray.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT LENGTH " + n2 + " IS LARGER THAN BUFFER SIZE " + byArray.length);
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        if (!this.blf.isInitialized()) {
            this.blf.initialize(this.bfKey);
        }
        if (this.blf.weakKeyCheck()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("ECB key is weak!", this.bfKey));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Key set Ok!", this.bfKey));
        }
        n3 = this.compute_enc_size(n2);
        n4 = n3 + 4;
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = 0;
        }
        byte[] byArray3 = new byte[n4];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Incoming unencrypted data is ", byArray));
        }
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message with " + n2 + " bytes aligned to " + byArray2.length + " bytes");
        }
        this.msgcvt(byArray2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Encrypting now...");
        }
        this.blf.encrypt(byArray2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Buffer after encryption", byArray2));
        }
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        this.msgcvt(byArray3);
        byte[] byArray4 = this.DH.normalize_key(n3 - n2);
        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Final buffer after byteflip and adding token length into the last 4 bytes ", byArray3));
        }
        return byArray3;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = new byte[4];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ONLY OFFSET = 0 IS ALLOWED!");
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_OFFSET_NOT_ZERO);
        }
        if (n2 > byArray.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT LENGTH " + n2 + " IS LARGER THAN BUFFER SIZE " + byArray.length);
            }
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        if (!this.blf.isInitialized()) {
            this.blf.initialize(this.bfKey);
        }
        if (this.blf.weakKeyCheck()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("ECB key is weak!", this.bfKey));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Key set Ok!", this.bfKey));
        }
        System.arraycopy(byArray, n2 - 4, byArray2, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = n2 - bigInteger.intValue() - 4;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("original encrypted length in INTEGER is " + n3);
        }
        int n4 = this.compute_enc_size(n3);
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, 0, byArray3, 0, n4);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump(" Before unwrap", byArray3));
        }
        this.msgcvt(byArray3);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Decrypt now...");
        }
        this.blf.decrypt(byArray3);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump(" after unwrap", byArray3));
        }
        this.msgcvt(byArray3);
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray4, 0, n3);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Final buffer after byteflip : ", byArray4));
            this.logger.debug("Leaving!");
        }
        return byArray4;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_INVALID_REQUEST);
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(11, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public boolean getCredDelegState() {
        return false;
    }

    public boolean getMutualAuthState() {
        return false;
    }

    public boolean getReplayDetState() {
        return false;
    }

    public boolean getSequenceDetState() {
        return false;
    }

    public boolean getAnonymityState() {
        return false;
    }

    public boolean getConfState() {
        return this.contextInit != 0;
    }

    public boolean getIntegState() {
        return this.contextInit != 0;
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.lifetime;
        }
        return 0;
    }

    public boolean isTransferable() throws GSSException {
        return false;
    }

    public boolean isProtReady() {
        return this.contextInit == 0 ? false : this.isEstablished();
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return Td1Mechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }
}

