/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class AuthMechParcel
extends Parcel {
    private Oid mechOid;
    boolean isDefaultMechanism = false;
    boolean m_bDefaultNegotiatingMechanism = false;
    int rank = 0;
    private static final int DER_OBJECT_IDENTIFIER = 6;

    public AuthMechParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        int n = this.length + this.flavorPosition;
        if (tDPacketStream.getInt() != 1) {
            return;
        }
        int n2 = tDPacketStream.getInt();
        byte[] byArray = new byte[n2 + 2];
        tDPacketStream.get(byArray, 2, n2);
        byArray[0] = 6;
        byArray[1] = (byte)n2;
        try {
            Oid oid = new Oid(byArray);
            this.setMechOid(oid);
        }
        catch (GSSException gSSException) {
            throw ErrorFactory.makeDriverJDBCException("TJ342", gSSException.getMessage());
        }
        block7: while (tDPacketStream.position() < n) {
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            int n3 = tDPacketStream.getInt();
            switch (s) {
                case 16: {
                    int n4 = tDPacketStream.getInt();
                    if (n4 == 0) continue block7;
                    this.isDefaultMechanism = true;
                    continue block7;
                }
                case 17: {
                    this.rank = tDPacketStream.getInt();
                    continue block7;
                }
                case 112: {
                    this.m_bDefaultNegotiatingMechanism = tDPacketStream.getInt() != 0;
                    continue block7;
                }
            }
            this.log.debug("AuthMech parcel: unknown property received: " + s);
            byte[] byArray2 = new byte[s2];
            tDPacketStream.get(byArray2, 0, s2);
        }
    }

    public void setMechOid(Oid oid) {
        this.mechOid = oid;
    }

    public Oid getMechOid() {
        return this.mechOid;
    }

    public String getMechOidString() {
        return this.mechOid.toString();
    }

    public boolean isDefaultMechanism() {
        return this.isDefaultMechanism;
    }

    public boolean isDefaultNegotiatingMechanism() {
        return this.m_bDefaultNegotiatingMechanism;
    }
}

