/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;

public abstract class TeraParameterMetaData {
    TDPreparedStatement m_ps;

    public TeraParameterMetaData(TDPreparedStatement tDPreparedStatement) throws SQLException {
        if (!tDPreparedStatement.hasParameterMetaData()) {
            throw ErrorFactory.makeDriverJDBCException("TJ442");
        }
        this.m_ps = tDPreparedStatement;
    }

    public int getParameterCount() throws SQLException {
        return this.m_ps.getNumberOfParameters();
    }

    public int isNullable(int n) throws SQLException {
        switch (this.m_ps.getParameterMarkerMetaDataItem(n).isNullable()) {
            case 89: {
                return 1;
            }
            case 78: {
                return 0;
            }
        }
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        return this.m_ps.getParameterMarkerMetaDataItem(n).isSigned() == 89;
    }

    public int getPrecision(int n) throws SQLException {
        return ColumnProperties.determinePrecision(this.m_ps.getParameterMarkerMetaDataItem(n));
    }

    public int getScale(int n) throws SQLException {
        short s = this.m_ps.getParameterMarkerMetaDataItem(n).getDataType();
        if (s == 0) {
            return 0;
        }
        return this.m_ps.getParameterMarkerMetaDataItem(n).getNumberOfFractionalDigits();
    }

    public int getParameterType(int n) throws SQLException {
        FullContentMetadataItem fullContentMetadataItem = this.m_ps.getParameterMarkerMetaDataItem(n);
        if (fullContentMetadataItem.getDataType() == 0) {
            return 0;
        }
        if (fullContentMetadataItem.getUdtIndicator() == 2) {
            return 2001;
        }
        return fullContentMetadataItem.getCustomerVisibleColumnType();
    }

    public String getParameterTypeName(int n) throws SQLException {
        FullContentMetadataItem fullContentMetadataItem = this.m_ps.getParameterMarkerMetaDataItem(n);
        return fullContentMetadataItem.getCustomerVisibleColumnTypeName();
    }

    public String getParameterClassName(int n) throws SQLException {
        short s = this.m_ps.getParameterMarkerMetaDataItem(n).getDataType();
        if (s == 0) {
            return null;
        }
        Class<?> clazz = this.m_ps.getConnection().getTypeMap().get(this.getParameterTypeName(n));
        if (clazz != null) {
            return clazz.getName();
        }
        return JDBC4Constants.getJavaClassNameForTdType(s);
    }

    public int getParameterMode(int n) throws SQLException {
        int n2 = JDBC4Constants.getTDTypeParameterMode(this.m_ps.getParameterMarkerMetaDataItem(n).getDataType());
        if (n2 != 0) {
            return n2;
        }
        switch (this.m_ps.getParameterMarkerMetaDataItem(n).getSPParameterDirection()) {
            case 73: {
                n2 = 1;
                break;
            }
            case 79: {
                n2 = 4;
                break;
            }
            case 66: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }
}

