/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.SQLException;

public class DeferredClob
extends DeferredLob {
    private Reader m_reader;
    private int m_parameterIndex;
    private int m_columnIndex;
    private String[] m_asAppMethodNames;
    private Encoder m_encoder;
    private boolean m_isOverflow = false;
    private char[] m_charArray = null;
    private CharBuffer m_charBuf = null;
    private long m_numCharsEncoded;
    private boolean m_bSlob = false;

    public DeferredClob(Reader reader, long l, int n, int n2, String[] stringArray, GenericTeradataConnection genericTeradataConnection, boolean bl) throws SQLException {
        this.m_reader = reader;
        this.m_nLength = l;
        this.m_parameterIndex = n;
        this.m_columnIndex = n2;
        this.m_asAppMethodNames = stringArray;
        this.m_encoder = new Encoder(genericTeradataConnection, bl);
    }

    public int writeDeferredLob(TDPacketStream tDPacketStream, int n) throws IOException, SQLException {
        if (this.m_nLength == 0L) {
            this.m_bAtEof = true;
            return 0;
        }
        if (!this.m_bSlob) {
            this.copyDeferredLob(n);
        }
        tDPacketStream.put(this.m_byteBuf.array(), 0, this.m_byteBuf.position());
        return this.m_byteBuf.position();
    }

    public void copyDeferredLob(int n) throws IOException, SQLException {
        if (this.m_byteBuf == null) {
            this.m_byteBuf = ByteBuffer.allocate(n);
            this.m_charArray = new char[n];
        } else {
            this.m_byteBuf.rewind();
        }
        try {
            int n2;
            if (this.m_isOverflow) {
                n2 = this.m_charBuf.position();
                this.m_isOverflow = this.m_encoder.continueEncodeStream(this.m_byteBuf, this.m_parameterIndex, this.m_columnIndex, this.m_asAppMethodNames, this.m_numCharsEncoded + 1L);
                this.m_numCharsEncoded += (long)(this.m_charBuf.position() - n2);
            }
            while (!this.m_isOverflow) {
                n2 = this.m_nLength - this.m_nAmountRead >= (long)this.m_charArray.length ? this.m_charArray.length : (int)(this.m_nLength - this.m_nAmountRead);
                int n3 = this.m_reader.read(this.m_charArray, 0, n2);
                if (n3 == -1) {
                    this.m_bAtEof = true;
                } else {
                    this.m_nAmountRead += (long)n3;
                    this.m_charBuf = CharBuffer.wrap(this.m_charArray, 0, n3);
                    this.m_isOverflow = this.m_encoder.beginEncodeStream(this.m_charBuf, this.m_byteBuf, this.m_parameterIndex, this.m_columnIndex, this.m_asAppMethodNames, this.m_numCharsEncoded + 1L);
                    this.m_numCharsEncoded += (long)this.m_charBuf.position();
                    if (this.m_nLength != this.m_numCharsEncoded || this.m_isOverflow) continue;
                    this.m_bAtEof = true;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            long l = 0L;
            while (this.m_nLength != this.m_nAmountRead && (l = this.m_reader.skip(this.m_nLength - this.m_nAmountRead)) != 0L) {
                this.m_nAmountRead += l;
            }
            throw sQLException;
        }
    }

    public int readDeferredLob(int n) throws IOException, SQLException {
        if (this.m_nLength == 0L) {
            this.m_bAtEof = true;
            return 0;
        }
        this.m_bSlob = true;
        this.copyDeferredLob(n);
        return this.m_byteBuf.position();
    }
}

