/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;
import com.tenqube.visual_third.entity.Card;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.NotificationApp;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;
import tenqube.parser.constants.Constants;

public final class ReaderContract {
    private static final String TEXT_TYPE = " TEXT ";
    private static final String REAL_TYPE = " REAL ";
    private static final String INTEGER_TYPE = " INTEGER ";
    private static final String COMMA_SEP = " , ";
    private static final String DATE_TYPE = " DATETIME ";
    private static final String DEFAULT = " DEFAULT ";
    private static final String NOT_NULL = " NOT NULL ";
    private static final String PRIMARY_KEY = " PRIMARY KEY ";
    private static final String UNIQUE = " UNIQUE ";
    private static final String AUTOINCREMENT = " AUTOINCREMENT ";
    private static final String CREATE_TABLE = " CREATE TABLE ";
    private static final String CREATE_TABLE_IF_NOT_EXISTS = " CREATE TABLE IF NOT EXISTS ";
    private static final String DROP_TABLE_IF_EXISTS = " DROP TABLE IF EXISTS ";
    private static final String DEFAULT_TEXT = " 'none' ";
    private static final String DEFAULT_INT = " 0 ";
    private static final String DEFAULT_DATE = " current_timestamp ";

    private ReaderContract() {
    }

    public static class NotificationAppTable
    implements BaseColumns {
        public static final String TABLE_NAME = " NOTIFICATION_APPS ";
        public static final String ALIAS = " noti.";
        public static final String AS_ALIAS = " AS noti ";
        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_IMAGE = "image";
        public static final String COLUMN_PRIORITY = "priority";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  NOTIFICATION_APPS  (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , name TEXT  NOT NULL  DEFAULT  'none'  , image TEXT  NOT NULL  DEFAULT  'none'  , priority INTEGER  NOT NULL  DEFAULT  0  )";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO NOTIFICATION_APPS (_id,name,image,priority)VALUES";

        public static NotificationApp populateModel(Cursor c) {
            return new NotificationApp(c.getInt(c.getColumnIndex("_id")), c.getString(c.getColumnIndex(COLUMN_NAME)), c.getString(c.getColumnIndex(COLUMN_IMAGE)), c.getInt(c.getColumnIndex(COLUMN_PRIORITY)));
        }
    }

    public static class TransactionsTable
    implements BaseColumns {
        public static final String TABLE_NAME = " TRANSACTIONS";
        public static final String ALIAS = " tran.";
        public static final String AS_ALIAS = " AS tran ";
        public static final String COLUMN_TRAN_ID = "tranId";
        public static final String COLUMN_IDENTIFIER = "identifier";
        public static final String COLUMN_CARD_ID = "cardId";
        public static final String COLUMN_USER_CATEGORY_ID = "userCategoryId";
        public static final String COLUMN_COMPANY_ID = "companyId";
        public static final String COLUMN_CATEGORY_CODE = "categoryCode";
        public static final String COLUMN_FRANCHISE = "franchise";
        public static final String COLUMN_SPENT_DATE = "spentDate";
        public static final String COLUMN_FINISH_DATE = "finishDate";
        public static final String COLUMN_SPENT_LATITUDE = "spentLatitude";
        public static final String COLUMN_SPENT_LONGITUDE = "spentLongitude";
        public static final String COLUMN_SPENT_MONEY = "spentMoney";
        public static final String COLUMN_ORI_SPENT_MONEY = "oriSpentMoney";
        public static final String COLUMN_INSTALLMENT_COUNT = "installmentCount";
        public static final String COLUMN_KEYWORD = "keyword";
        public static final String COLUMN_SEARCH_KEYWORD = "searchKeyword";
        public static final String COLUMN_REPEAT_TYPE = "repeatType";
        public static final String COLUMN_CURRENCY = "currency";
        public static final String COLUMN_IS_DELETED = "isDeleted";
        public static final String COLUMN_DW_TYPE = "dwType";
        public static final String COLUMN_SENDER = "sender";
        public static final String COLUMN_FULL_SMS = "fullSms";
        public static final String COLUMN_SMS_DATE = "smsDate";
        public static final String COLUMN_SMS_TYPE = "smsType";
        public static final String COLUMN_REG_ID = "regId";
        public static final String COLUMN_IS_OFFSET = "isOffset";
        public static final String COLUMN_IS_CUSTOM = "isCustom";
        public static final String COLUMN_IS_USER_UPDATE = "isUserUpdate";
        public static final String COLUMN_IS_UPDATE_ALL = "isUpdateAll";
        public static final String COLUMN_MEMO = "memo";
        public static final String COLUMN_CLASS_CODE = "classCode";
        public static final String COLUMN_IS_SYNCED = "isSynced";
        public static final String COLUMN_SHOULD_RETRY_SEARCH = "shouldRetrySearch";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE  TRANSACTIONS (tranId INTEGER  PRIMARY KEY  AUTOINCREMENT  , identifier REAL  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , userCategoryId INTEGER  NOT NULL  DEFAULT  0  , companyId INTEGER  NOT NULL  DEFAULT  0  , franchise TEXT  NOT NULL  DEFAULT  'none'  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , oriSpentMoney REAL  NOT NULL  DEFAULT  0  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , keyword TEXT  NOT NULL  DEFAULT  'none'  , searchKeyword TEXT  NOT NULL  DEFAULT  'none'  , repeatType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isDeleted INTEGER  NOT NULL  DEFAULT  0  , dwType INTEGER  NOT NULL  DEFAULT  0  , sender TEXT  NOT NULL  DEFAULT  'none'  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , smsDate DATETIME  NOT NULL  DEFAULT  0  , smsType INTEGER  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isCustom INTEGER  NOT NULL  DEFAULT  0  , isUserUpdate INTEGER  NOT NULL  DEFAULT  0  , isUpdateAll INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , classCode TEXT  NOT NULL  DEFAULT  'none'  , isSynced INTEGER  NOT NULL  DEFAULT  0  , shouldRetrySearch INTEGER  NOT NULL  DEFAULT  0 )";
        public static final String indexing = "CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType)";
        public static final String indexing2 = "CREATE INDEX qlip_transaction_idx3 ON  TRANSACTIONS (tranId)";

        public static Transaction populateModel(Cursor c) {
            return new Transaction(c.getInt(c.getColumnIndex(COLUMN_TRAN_ID)), c.getLong(c.getColumnIndex(COLUMN_IDENTIFIER)), c.getInt(c.getColumnIndex(COLUMN_CARD_ID)), c.getInt(c.getColumnIndex(COLUMN_USER_CATEGORY_ID)), c.getInt(c.getColumnIndex(COLUMN_COMPANY_ID)), c.getString(c.getColumnIndex(COLUMN_FRANCHISE)), c.getInt(c.getColumnIndex(COLUMN_CATEGORY_CODE)), c.getString(c.getColumnIndex(COLUMN_SPENT_DATE)), c.getString(c.getColumnIndex(COLUMN_FINISH_DATE)), c.getDouble(c.getColumnIndex(COLUMN_SPENT_LATITUDE)), c.getDouble(c.getColumnIndex(COLUMN_SPENT_LONGITUDE)), c.getDouble(c.getColumnIndex(COLUMN_SPENT_MONEY)), c.getDouble(c.getColumnIndex(COLUMN_ORI_SPENT_MONEY)), c.getInt(c.getColumnIndex(COLUMN_INSTALLMENT_COUNT)), c.getString(c.getColumnIndex(COLUMN_KEYWORD)), c.getString(c.getColumnIndex(COLUMN_SEARCH_KEYWORD)), c.getInt(c.getColumnIndex(COLUMN_REPEAT_TYPE)), c.getString(c.getColumnIndex(COLUMN_CURRENCY)), c.getInt(c.getColumnIndex(COLUMN_IS_DELETED)) == 1, c.getInt(c.getColumnIndex(COLUMN_DW_TYPE)), c.getString(c.getColumnIndex(COLUMN_SENDER)), c.getString(c.getColumnIndex(COLUMN_FULL_SMS)), c.getString(c.getColumnIndex(COLUMN_SMS_DATE)), c.getInt(c.getColumnIndex(COLUMN_SMS_TYPE)), c.getInt(c.getColumnIndex(COLUMN_REG_ID)), c.getInt(c.getColumnIndex(COLUMN_IS_OFFSET)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_CUSTOM)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_USER_UPDATE)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_UPDATE_ALL)) == 1, c.getString(c.getColumnIndex(COLUMN_MEMO)), c.getString(c.getColumnIndex(COLUMN_CLASS_CODE)), c.getInt(c.getColumnIndex(COLUMN_IS_SYNCED)) == 1);
        }
    }

    public static class CategoryTable
    implements BaseColumns {
        public static final String TABLE_NAME = " CATEGORIES ";
        public static final String ALIAS = " ca.";
        public static final String AS_ALIAS = " AS ca ";
        public static final String COLUMN_CODE = "cateCode";
        public static final String COLUMN_LARGE = "largeName";
        public static final String COLUMN_MEDIUM = "mediumName";
        public static final String COLUMN_SMALL = "smallName";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  CATEGORIES  (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cateCode INTEGER  NOT NULL  DEFAULT  0  , largeName TEXT  NOT NULL  DEFAULT  'none'  , mediumName TEXT  NOT NULL  DEFAULT  'none'  , smallName TEXT  NOT NULL  DEFAULT  'none'  )";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO CATEGORIES (_id,cateCode,largeName,mediumName,smallName)VALUES";

        public static Category populateModel(Cursor c) {
            return new Category(c.getInt(c.getColumnIndex("_id")), c.getInt(c.getColumnIndex(COLUMN_CODE)), c.getString(c.getColumnIndex(COLUMN_LARGE)), c.getString(c.getColumnIndex(COLUMN_MEDIUM)), c.getString(c.getColumnIndex(COLUMN_SMALL)));
        }
    }

    public static class UserCategoryTable
    implements BaseColumns {
        public static final String TABLE_NAME = " USER_CATEGORIES ";
        public static final String ALIAS = " userCate.";
        public static final String AS_ALIAS = " AS userCate ";
        public static final String COLUMN_USER_CATE_ID = "ucId";
        public static final String COLUMN_CODE = "repCode";
        public static final String COLUMN_IS_EXCEPT = "isCateExcept";
        public static final String COLUMN_IS_MAIN = "isCateMain";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  USER_CATEGORIES  (ucId INTEGER  PRIMARY KEY  AUTOINCREMENT  , repCode INTEGER  NOT NULL  DEFAULT  0  , isCateExcept INTEGER  NOT NULL  DEFAULT  0  , isCateMain INTEGER  NOT NULL  DEFAULT  0  )";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  USER_CATEGORIES ";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO USER_CATEGORIES (ucId,repCode,isCateExcept,isCateMain)VALUES";

        public static UserCategory populateModel(Cursor c) {
            return new UserCategory(c.getInt(c.getColumnIndex(COLUMN_USER_CATE_ID)), c.getInt(c.getColumnIndex(COLUMN_CODE)), c.getInt(c.getColumnIndex(COLUMN_IS_EXCEPT)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_MAIN)) == 1);
        }
    }

    public static class CardTable
    implements BaseColumns {
        public static final String TABLE_NAME = " CARDS";
        public static final String AS_ALIAS = " AS card ";
        public static final String ALIAS = " card.";
        public static final String COLUMN_CARD_ID = "cId";
        public static final String COLUMN_CARD_NAME = "cardName";
        public static final String COLUMN_CARD_TYPE = "cardType";
        public static final String COLUMN_CARD_SUB_TYPE = "cardSubType";
        public static final String COLUMN_CHANGE_NAME = "changeName";
        public static final String COLUMN_CHANGE_TYPE = "changeType";
        public static final String COLUMN_CHANGE_SUB_TYPE = "changeSubType";
        public static final String COLUMN_BILLING_DAY = "billingDay";
        public static final String COLUMN_CARD_BALANCE = "balance";
        public static final String COLUMN_CARD_MEMO = "cardMemo";
        public static final String COLUMN_IS_EXCEPT = "isCardExcept";
        public static final String COLUMN_IS_CUSTOM = "isCardCustom";
        public static final String COLUMN_IS_DELETED = "isCardDeleted";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  CARDS (cId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , changeName TEXT  NOT NULL  DEFAULT  'none'  , changeType INTEGER  NOT NULL  DEFAULT  0  , changeSubType INTEGER  NOT NULL  DEFAULT  0  , billingDay INTEGER  NOT NULL  DEFAULT  1  , balance REAL  NOT NULL  DEFAULT  0  , cardMemo TEXT  NOT NULL  DEFAULT  'none'  , isCardExcept INTEGER  NOT NULL  DEFAULT  0  , isCardCustom INTEGER  NOT NULL  DEFAULT  0  , isCardDeleted INTEGER  NOT NULL  DEFAULT  0  ,  UNIQUE (cardName , cardType , cardSubType) ON CONFLICT REPLACE )";
        public static final String indexing = "CREATE INDEX visual_card_idx ON  CARDS (cardName,cardType,cardSubType)";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO CARDS(cardName,cardType,cardSubType,changeName,changeType,changeSubType,billingDay,balance,cardMemo,isCardExcept,isCardCustom,isCardDeleted)VALUES";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  CARDS";

        public static ContentValues populateData() {
            ContentValues values = new ContentValues();
            values.put(COLUMN_CARD_NAME, "\ud604\uae08");
            values.put(COLUMN_CHANGE_NAME, "\ud604\uae08");
            values.put(COLUMN_CARD_TYPE, Integer.valueOf(Constants.CardType.CASH.ordinal()));
            values.put(COLUMN_CHANGE_TYPE, Integer.valueOf(Constants.CardType.CASH.ordinal()));
            values.put(COLUMN_CARD_SUB_TYPE, Integer.valueOf(0));
            values.put(COLUMN_CHANGE_SUB_TYPE, Integer.valueOf(0));
            values.put(COLUMN_BILLING_DAY, Integer.valueOf(1));
            return values;
        }

        public static Card populateModel(Cursor c) {
            return new Card(c.getInt(c.getColumnIndex(COLUMN_CARD_ID)), c.getString(c.getColumnIndex(COLUMN_CARD_NAME)), c.getInt(c.getColumnIndex(COLUMN_CARD_TYPE)), c.getInt(c.getColumnIndex(COLUMN_CARD_SUB_TYPE)), c.getString(c.getColumnIndex(COLUMN_CHANGE_NAME)), c.getInt(c.getColumnIndex(COLUMN_CHANGE_TYPE)), c.getInt(c.getColumnIndex(COLUMN_CHANGE_SUB_TYPE)), c.getInt(c.getColumnIndex(COLUMN_BILLING_DAY)), c.getDouble(c.getColumnIndex(COLUMN_CARD_BALANCE)), c.getString(c.getColumnIndex(COLUMN_CARD_MEMO)), c.getInt(c.getColumnIndex(COLUMN_IS_EXCEPT)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_CUSTOM)) == 1, c.getInt(c.getColumnIndex(COLUMN_IS_DELETED)) == 1);
        }
    }

    public static class ConditionTable
    implements BaseColumns {
        public static final String TABLE_NAME = " CONDITIONS";
        public static final String AS_ALIAS = " AS condition ";
        public static final String ALIAS = " condition.";
        public static final String COLUMN_CONDITION_ID = "conditionId";
        public static final String COLUMN_CONTENT_ID = "cId";
        public static final String COLUMN_STANDARD = "standard";
        public static final String COLUMN_FUNC_TYPE = "funcType";
        public static final String COLUMN_FUNC_KEYS = "funcKeys";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  CONDITIONS (conditionId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cId INTEGER  NOT NULL  DEFAULT  0  , standard TEXT  NOT NULL  DEFAULT  0  , funcType TEXT  NOT NULL  DEFAULT  0  , funcKeys TEXT  NOT NULL  DEFAULT  'none'  )";
        public static final String indexing = "CREATE INDEX visual_conditions_idx ON  CONDITIONS (cId)";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO CONDITIONS(conditionId,cId,standard,funcType,funcKeys)VALUES";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  CONDITIONS";

        public static Condition populateModel(Cursor c) {
            return new Condition(c.getInt(c.getColumnIndex(COLUMN_CONDITION_ID)), c.getInt(c.getColumnIndex(COLUMN_CONTENT_ID)), c.getString(c.getColumnIndex(COLUMN_STANDARD)), c.getString(c.getColumnIndex(COLUMN_FUNC_TYPE)), c.getString(c.getColumnIndex(COLUMN_FUNC_KEYS)));
        }
    }

    public static class ContentTable
    implements BaseColumns {
        public static final String TABLE_NAME = " CONTENTS";
        public static final String AS_ALIAS = " AS content ";
        public static final String ALIAS = " content.";
        public static final String COLUMN_CONTENT_ID = "contentId";
        public static final String COLUMN_PRIORITY = "priority";
        public static final String COLUMN_CATEGORY_PRIORITY = "categoryPriority";
        public static final String COLUMN_NUM_OF_OCCURRENCE = "numOfOccurrence";
        public static final String COLUMN_LARGE_CODE = "lCode";
        public static final String COLUMN_RAW_KEYS = "rawKeys";
        public static final String COLUMN_LINK_TO = "linkTo";
        public static final String COLUMN_LABEL = "label";
        public static final String COLUMN_LARGE_CONTENT = "largeContent";
        public static final String COLUMN_LARGE_KEYS = "largeKeys";
        public static final String COLUMN_MEDIUM_CONTENT = "mediumContent";
        public static final String COLUMN_MEDIUM_KEYS = "mediumKeys";
        public static final String COLUMN_IMAGE = "image";
        public static final String SQL_CREATE_ENTRIES = " CREATE TABLE IF NOT EXISTS  CONTENTS (contentId INTEGER  PRIMARY KEY  AUTOINCREMENT  , priority INTEGER  NOT NULL  DEFAULT  0  , categoryPriority INTEGER  NOT NULL  DEFAULT  0  , numOfOccurrence INTEGER  NOT NULL  DEFAULT  0  , lCode INTEGER  NOT NULL  DEFAULT  0  , rawKeys TEXT  NOT NULL  DEFAULT  0  , linkTo TEXT  NOT NULL  DEFAULT  0  , label TEXT  NOT NULL  DEFAULT  'none'  , largeContent TEXT  NOT NULL  DEFAULT  'none'  , largeKeys TEXT  NOT NULL  DEFAULT  'none'  , mediumContent TEXT  NOT NULL  DEFAULT  'none'  , mediumKeys TEXT  NOT NULL  DEFAULT  'none'  , image TEXT  NOT NULL  DEFAULT  'none'  )";
        public static final String indexing = "CREATE INDEX visual_contents_idx ON  CONTENTS (lCode)";
        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO CONTENTS(contentId,priority,categoryPriority,numOfOccurrence,lCode,rawKeys,linkTo,label,largeContent,largeKeys,mediumContent,mediumKeys,image)VALUES";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  CONTENTS";

        public static Content populateModel(Cursor c) {
            return new Content(c.getInt(c.getColumnIndex(COLUMN_CONTENT_ID)), c.getInt(c.getColumnIndex(COLUMN_PRIORITY)), c.getInt(c.getColumnIndex(COLUMN_CATEGORY_PRIORITY)), c.getInt(c.getColumnIndex(COLUMN_NUM_OF_OCCURRENCE)), c.getInt(c.getColumnIndex(COLUMN_LARGE_CODE)), c.getString(c.getColumnIndex(COLUMN_RAW_KEYS)), c.getString(c.getColumnIndex(COLUMN_LINK_TO)), c.getString(c.getColumnIndex(COLUMN_LABEL)), c.getString(c.getColumnIndex(COLUMN_LARGE_CONTENT)), c.getString(c.getColumnIndex(COLUMN_LARGE_KEYS)), c.getString(c.getColumnIndex(COLUMN_MEDIUM_CONTENT)), c.getString(c.getColumnIndex(COLUMN_MEDIUM_KEYS)), c.getString(c.getColumnIndex(COLUMN_IMAGE)));
        }
    }

    public static class CurrencyTable
    implements BaseColumns {
        public static final String TABLE_NAME = " CURRENCY";
        public static final String ALIAS = " currency.";
        public static final String AS_ALIAS = " AS currency ";
        public static final String COLUMN_CURRENCY_ID = "currency_id_pk";
        public static final String COLUMN_FROM = "currency_from";
        public static final String COLUMN_TO = "currency_to";
        public static final String COLUMN_RATE = "currency_rate";
        public static final String COLUMN_CREATED_AT = "currency_created_at";
        public static final String SQL_CREATE_TABLE = " CREATE TABLE IF NOT EXISTS  CURRENCY (currency_id_pk INTEGER  PRIMARY KEY  , currency_from TEXT  NOT NULL  DEFAULT  'none'  , currency_to TEXT  NOT NULL  DEFAULT  'none'  , currency_rate REAL  NOT NULL  DEFAULT  0  , currency_created_at DATETIME  NOT NULL  DEFAULT  current_timestamp  ,  UNIQUE (currency_from , currency_to) )";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  CURRENCY";
        public static final String INSERT_CURRENCY = "INSERT OR REPLACE INTO CURRENCY(currency_from,currency_to,currency_rate,currency_created_at)VALUES";

        public static Currency populateModel(Cursor c) {
            return new Currency(c.getInt(c.getColumnIndex(COLUMN_CURRENCY_ID)), c.getString(c.getColumnIndex(COLUMN_FROM)), c.getString(c.getColumnIndex(COLUMN_TO)), c.getFloat(c.getColumnIndex(COLUMN_RATE)), c.getString(c.getColumnIndex(COLUMN_CREATED_AT)));
        }

        public static ContentValues populateContent(Currency model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_FROM, model.getFrom());
            values.put(COLUMN_TO, model.getTo());
            values.put(COLUMN_RATE, Double.valueOf(model.getRate()));
            values.put(COLUMN_CREATED_AT, model.getCreatedAt());
            return values;
        }
    }

    public static class NotificationsTable
    implements BaseColumns {
        public static final String TABLE_NAME = " NOTIFICATIONS ";
        public static final String ALIAS = " noti.";
        public static final String AS_ALIAS = " AS noti ";
        public static final String COLUMN_NOTI_ID = "noti_id_pk";
        public static final String COLUMN_NAME = "noti_name";
        public static final String COLUMN_TITLE = "noti_title";
        public static final String COLUMN_CONTENT = "noti_content";
        public static final String COLUMN_TICKER = "noti_ticker";
        public static final String COLUMN_ALARM_TYPE = "noti_alarm_type";
        public static final String COLUMN_DAY_OF_WEEK = "noti_day_of_week";
        public static final String COLUMN_HOUR = "noti_hour";
        public static final String COLUMN_DAY = "noti_day";
        public static final String COLUMN_ENABLE = "noti_enable";
        public static final String COLUMN_CREATED_AT = "noti_created_at";
        public static final String SQL_CREATE_TABLE = " CREATE TABLE IF NOT EXISTS  NOTIFICATIONS  (noti_id_pk INTEGER  PRIMARY KEY  , noti_name TEXT  NOT NULL  DEFAULT  'none'  , noti_title TEXT  NOT NULL  DEFAULT  'none'  , noti_content TEXT  NOT NULL  DEFAULT  'none'  , noti_ticker TEXT  NOT NULL  DEFAULT  'none'  , noti_alarm_type INTEGER  NOT NULL  DEFAULT  0  , noti_day_of_week INTEGER  NOT NULL  DEFAULT  0  , noti_hour INTEGER  NOT NULL  DEFAULT  0  , noti_day INTEGER  NOT NULL  DEFAULT  0  , noti_enable INTEGER  NOT NULL  DEFAULT  1  , noti_created_at DATETIME  NOT NULL  DEFAULT  current_timestamp  ,  UNIQUE (noti_name) )";
        public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  NOTIFICATIONS ";
        public static final String INSERT_NOTIFICATION = "INSERT OR REPLACE INTO NOTIFICATIONS (noti_id_pk,noti_name,noti_title,noti_content,noti_ticker,noti_alarm_type,noti_day_of_week,noti_hour,noti_day,noti_enable,noti_created_at)VALUES";

        public static VisualNotification populateModel(Cursor c) {
            return new VisualNotification(c.getInt(c.getColumnIndex(COLUMN_NOTI_ID)), c.getString(c.getColumnIndex(COLUMN_NAME)), c.getString(c.getColumnIndex(COLUMN_TITLE)), c.getString(c.getColumnIndex(COLUMN_CONTENT)), c.getString(c.getColumnIndex(COLUMN_TICKER)), c.getInt(c.getColumnIndex(COLUMN_ALARM_TYPE)), c.getInt(c.getColumnIndex(COLUMN_DAY_OF_WEEK)), c.getInt(c.getColumnIndex(COLUMN_DAY)), c.getInt(c.getColumnIndex(COLUMN_HOUR)), c.getInt(c.getColumnIndex(COLUMN_ENABLE)) == 1);
        }

        public static ContentValues populateContent(VisualNotification model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_NOTI_ID, Integer.valueOf(model.getId()));
            values.put(COLUMN_NAME, model.getName());
            values.put(COLUMN_TITLE, model.getTitle());
            values.put(COLUMN_CONTENT, model.getContent());
            values.put(COLUMN_TICKER, model.getTicker());
            values.put(COLUMN_ALARM_TYPE, Integer.valueOf(model.getAlarmType()));
            values.put(COLUMN_DAY_OF_WEEK, Integer.valueOf(model.getDayOfWeek()));
            values.put(COLUMN_HOUR, Integer.valueOf(model.getHour()));
            values.put(COLUMN_DAY, Integer.valueOf(model.getDay()));
            values.put(COLUMN_ENABLE, Integer.valueOf(model.isEnable() ? 1 : 0));
            values.put(COLUMN_CREATED_AT, model.getCreatedAt());
            return values;
        }
    }
}

