/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.FontUtil;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;

public class TransactionPopupActivity
extends Activity {
    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    public static final String ACTION_TRAN_POPUP = "tenqube.intent.action.ACTION_TRAN_POPUP";

    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) throws ParameterException, AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        if (transactionPopupInfo == null) {
            throw new ParameterException("Check transactionPopupInfo.");
        }
        if (!PrefManager.getInstance(context).isEnabled("TENQUBE_TRAN_POPUP", true)) {
            return;
        }
        try {
            Intent intent = new Intent(context, TransactionPopupActivity.class);
            intent.addFlags(1409417216);
            intent.putExtra(ARG_TRANSACTION, (Serializable)transactionPopupInfo);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            final TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo)this.getIntent().getSerializableExtra(ARG_TRANSACTION);
            if (transactionPopupInfo == null || !PrefManager.getInstance((Context)this).isEnabled("TENQUBE_TRAN_POPUP", true)) {
                this.finish();
                return;
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("TransactionPopupActivity"));
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setContentView(R.layout.activity_transaction_popup);
            FontUtil.setAllTextView(this.findViewById(R.id.container));
            DisplayMetrics dm = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(dm);
            TextView companyTitleTextView = (TextView)this.findViewById(R.id.company_title);
            companyTitleTextView.setText((CharSequence)transactionPopupInfo.getCompanyTitle());
            TextView companyAddressTextView = (TextView)this.findViewById(R.id.company_address);
            companyAddressTextView.setVisibility(TextUtils.isEmpty((CharSequence)transactionPopupInfo.getCompanyAddress()) ? 8 : 0);
            companyAddressTextView.setText((CharSequence)transactionPopupInfo.getCompanyAddress());
            TextView spentDateTextView = (TextView)this.findViewById(R.id.spent_date);
            spentDateTextView.setText((CharSequence)transactionPopupInfo.getSpentDate());
            TextView paymentTextView = (TextView)this.findViewById(R.id.payment);
            paymentTextView.setText((CharSequence)transactionPopupInfo.getPayment());
            TextView installmentTextView = (TextView)this.findViewById(R.id.installment);
            installmentTextView.setText((CharSequence)transactionPopupInfo.getInstallmentStr());
            TextView spentMoneyTextView = (TextView)this.findViewById(R.id.spent_money);
            spentMoneyTextView.setText((CharSequence)transactionPopupInfo.getSpentMoneyStr());
            this.findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(View view) {
                    try {
                        VisualRepository repository = VisualRepository.getInstance(TransactionPopupActivity.this.getApplicationContext());
                        int tranId = repository.loadTranId(transactionPopupInfo.getTransaction().getParsedTransaction().identifier);
                        if (tranId == 0) {
                            return;
                        }
                        Category category = repository.loadCategory(transactionPopupInfo.getCategoryCode());
                        if (category == null) {
                            return;
                        }
                        String path = Utils.makeDialogPath(tranId, transactionPopupInfo.getTransaction().getParsedTransaction().keyword, category.getLarge(), category.getMedium(), category.getLargeCode(), category.getMediumCode(), transactionPopupInfo.getTransaction().getParsedTransaction().spentDate, transactionPopupInfo.getTransaction().getSpentMoney(), transactionPopupInfo.getTransaction().getParsedTransaction().installmentCount, transactionPopupInfo.getTransaction().getCardId(), transactionPopupInfo.getTransaction().getParsedTransaction().memo, transactionPopupInfo.getTransaction().getParsedTransaction().dwType == 1 ? "expense" : "income", "popup");
                        String deepLink = PrefManager.getInstance(TransactionPopupActivity.this.getApplicationContext()).loadStringValue("TENQUBE_DEEP_LINK", "");
                        if (TextUtils.isEmpty((CharSequence)deepLink)) {
                            VisualWebActivity.startActivity(TransactionPopupActivity.this, "", path);
                        } else {
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)deepLink));
                            intent.putExtra("PATH", path);
                            TransactionPopupActivity.this.startActivity(intent);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        TransactionPopupActivity.this.finish();
                    }
                }
            });
            this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TransactionPopupActivity.this.finish();
                }
            });
            ImageView categoryImageView = (ImageView)this.findViewById(R.id.category);
            categoryImageView.setImageResource(Utils.getCategoryIcon(transactionPopupInfo.getLargeCode()));
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent(ACTION_TRAN_POPUP));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }
}

