/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

public class SystemImpl
extends Base
implements VisualInterface.System {
    private String callbackNoti;

    public SystemImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error) {
        super(context, contractor, webView, error);
    }

    @Override
    public void onNotiCallback(String json) {
        this.callbackWithStr(this.callbackNoti, json);
    }

    @Override
    @JavascriptInterface
    public void startNotiListener(String callback) {
        String funcName = "startNotiListener";
        try {
            Validator.isStr(callback, 100);
            this.callbackNoti = callback;
            this.contractor.showNotiCatch();
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void goNotiSettings(String callback) {
        String funcName = "goNotiSettings";
        try {
            Validator.isStr(callback, 100);
            this.callbackNoti = callback;
            try {
                this.contractor.goNotiSettings();
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                this.onError(funcName, e.toString());
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNotiEnabled() {
        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
            return false;
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNetworkConnected() {
        String funcName = "isNetworkConnected";
        try {
            ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
            return true;
        }
    }
}

