package com.tenqube.visual_third.manager.bulk;

import android.Manifest;
import android.app.ProgressDialog;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.ui.VisualActivityFragment;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class BulkParsingManagerImpl implements BulkParsingManager {

    public static final int REQUEST_SMS = 0;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;

    private final Fragment fragment;
    private BulkLoader bulkLoader;
    private ProgressDialog progressDialog;

    private Callback<Boolean> callback;

    public BulkParsingManagerImpl(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    @AfterPermissionGranted(REQUEST_SMS)
    public void start(Callback<Boolean> callback) {
        this.callback = callback;

        String[] perms = {Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS};
        if (PermissionUtil.hasPermissions(fragment.getContext(), perms)) {
            startParsing();
        } else {
            PermissionUtil.requestPermissions(fragment, REQUEST_SMS, perms);
        }

    }

    private void startParsing() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {

                    LOGI("VisualFlow", "startBulk parsing", mIsDebug);

                    bulkLoader = new BulkLoader(fragment.getContext(), handler, new BulkLoader.OnSmsLoadFinished() {
                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if(handler != null) handler.sendEmptyMessage(FINISH);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    // 2. 프로그레스 다이얼로그 show
                    LOGI(VisualActivityFragment.TAG, "2. 프로그레스 다이얼로그 show", mIsDebug);
                    handler.sendEmptyMessage(SHOW_PROGRESS_BAR);

                    // 3. 지난 6개월 문자 파싱 시작
                    LOGI(VisualActivityFragment.TAG, "3. 지난 6개월 문자 파싱 시작", mIsDebug);
                    bulkLoader.doParsing();

                } catch (Exception e) {
                    handler.sendEmptyMessage(ERROR);
                }

            }
        }).start();
    }

    @Override
    public void onPermissionGranted() {
        LOGI("VisualFlow", "onPermissionGranted", mIsDebug);

        startParsing();
    }

    @Override
    public void onPermissionsDenied() {
        callback.onComplete(false);
    }

    private void showProgress() {
        try {
            progressDialog = new ProgressDialog(fragment.getContext());
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setMessage(fragment.getString(R.string.progress_description));
            progressDialog.setCancelable(false);
            progressDialog.setCanceledOnTouchOutside(false);
//            progressDialog.setProgressNumberFormat("$1");
            progressDialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setProgressValue(int now, int total, int percent) {
        progressDialog.setProgress(percent);
    }

    private Handler handler = new Handler(new Handler.Callback() { // 핸들러로 전달받은 값 progress 값 세팅해주기
        @Override
        public boolean handleMessage(final Message msg) {

            try {
                switch (msg.what) {
                    case PROGRESS:
                        if(progressDialog != null) {
                            Bundle bundle = msg.getData();
                            if(bundle != null) {
                                setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                            }
                        }
                        break;

                    case SHOW_PROGRESS_BAR:
                        try {
                            showProgress();
                        } catch (Exception e) {
                            progressDialog = null;
                        }

                        break;
                    case FINISH:
                    case ERROR:
                    default:
                        if(progressDialog != null) {
                            progressDialog.dismiss();
                        }
                        callback.onComplete(true);
                        break;
                }
            } catch (Exception e) {
                if(progressDialog != null) {
                    progressDialog.dismiss();
                }
                callback.onComplete(false);
            }

            return false;
        }
    });
}
