/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.bulk.BulkParsingManager;
import com.tenqube.visual_third.manager.bulk.BulkParsingManagerImpl;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.NotificationDialogFragment;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.FontUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualActivityFragment
extends Fragment
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
ViewContractor,
NotificationDialogFragment.Callback,
PermissionUtil.PermissionCallbacks {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_UID = "UID";
    public static final String ARG_PATH = "PATH";
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    private VisualRepository repository;
    private ResourceManager resourceManager;
    private PrefManager prefManager;
    private VisualAlarmManager alarmManager;
    private VisualApi api;
    private String mFailingUrl;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private boolean isPageLoaded;
    private OnFragBackListener listener;
    private FrameLayout bulkContainer;
    private ProgressBar progressBar;
    private String uid;
    private String path;
    private BulkParsingManager bulkParsingManager;
    private FrameLayout errorView;
    private boolean isError;
    private boolean shouldShowNotiPopup;

    public static VisualActivityFragment newInstance(String uid, String path) {
        VisualActivityFragment fragment = new VisualActivityFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_UID, uid);
        bundle.putString(ARG_PATH, path);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (this.getArguments() != null) {
            this.uid = this.getArguments().getString(ARG_UID, "");
            this.path = this.getArguments().getString(ARG_PATH, "");
        }
        LogUtil.LOGI((String)TAG, (String)("Params(UID)" + this.uid), (boolean)ParserService.mIsDebug);
        LogUtil.LOGI((String)TAG, (String)("Params(path)" + this.path), (boolean)ParserService.mIsDebug);
        this.api = VisualApi.getInstance((Context)this.getActivity());
        this.prefManager = PrefManager.getInstance((Context)this.getActivity());
        this.resourceManager = ResourceManager.getInstance(this.api, this.prefManager);
        this.repository = VisualRepository.getInstance((Context)this.getActivity());
        this.alarmManager = VisualAlarmManager.getInstance((Context)this.getActivity());
        AnswerManager.initFabric((Context)this.getActivity());
        AnswerManager.onKeyMetric(new LogRequest("VisualActivityFragment"));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_visual_web, container, false);
        FontUtil.setAllTextView(view);
        return view;
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        block7: {
            super.onViewCreated(view, savedInstanceState);
            try {
                this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
                this.progressBar.setVisibility(8);
                this.errorView = (FrameLayout)view.findViewById(R.id.error_container);
                this.errorView.setVisibility(8);
                view.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        VisualActivityFragment.this.retry();
                    }
                });
                this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh_layout);
                this.swipeRefreshLayout.setEnabled(false);
                this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
                this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                    public void onRefresh() {
                        if (VisualActivityFragment.this.progressBar != null) {
                            VisualActivityFragment.this.progressBar.setVisibility(8);
                        }
                        VisualActivityFragment.this.swipeRefreshLayout.setRefreshing(false);
                        VisualActivityFragment.this.webview.reload();
                    }
                });
                this.webview = (WebView)view.findViewById(R.id.visual_web_view);
                this.webview.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.colorWebView));
                this.webview.getSettings().setTextZoom(100);
                this.errorInterface = new ErrorImpl((Context)this.getActivity(), this, this.webview);
                this.logInterface = new LogImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
                this.repoInterface = new RepoImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, VisualRepository.getInstance((Context)this.getActivity()), this.api, new AnalysisServiceImpl((Context)this.getActivity(), this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev")), this.alarmManager);
                this.uiInterface = new UiImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, new BottomDialog((Activity)this.getActivity()));
                this.systemInterface = new SystemImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
                this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
                this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
                this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
                this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
                this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
                WebViewHelper.settings(this.webview);
                this.webview.setWebViewClient(new WebViewClient(){

                    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                        VisualActivityFragment.this.isError = true;
                        VisualActivityFragment.this.mFailingUrl = failingUrl;
                        if (VisualActivityFragment.this.progressBar != null) {
                            VisualActivityFragment.this.progressBar.setVisibility(8);
                        }
                        VisualActivityFragment.this.loadErrorUrl();
                    }

                    public void onPageStarted(WebView view, String url, Bitmap favicon) {
                        super.onPageStarted(view, url, favicon);
                        if (VisualActivityFragment.this.progressBar != null) {
                            VisualActivityFragment.this.progressBar.setVisibility(0);
                        }
                    }

                    public void onPageCommitVisible(WebView view, String url) {
                        if (VisualActivityFragment.this.progressBar != null) {
                            VisualActivityFragment.this.progressBar.setVisibility(8);
                        }
                        super.onPageCommitVisible(view, url);
                    }

                    public void onPageFinished(WebView view, String url) {
                        if (!VisualActivityFragment.this.isError) {
                            VisualActivityFragment.this.errorView.setVisibility(8);
                        }
                        VisualActivityFragment.this.isError = false;
                        super.onPageFinished(view, url);
                        if (VisualActivityFragment.this.progressBar != null) {
                            VisualActivityFragment.this.progressBar.setVisibility(8);
                        }
                        if (VisualActivityFragment.this.shouldShowNotiPopup) {
                            VisualActivityFragment.this.shouldShowNotiPopup = false;
                            if (!Utils.isNotiEnabled((Context)VisualActivityFragment.this.getActivity())) {
                                VisualActivityFragment.this.showNotiCatch();
                            }
                        }
                    }
                });
                if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                    this.webview.getSettings().setCacheMode(2);
                }
                this.bulkContainer = (FrameLayout)view.findViewById(R.id.start_bulk);
                this.bulkContainer.setVisibility(8);
                TextView bulkTextView = (TextView)view.findViewById(R.id.start_bulk_txt);
                Typeface typeface = FontUtil.getFont(this.getContext(), "Tenqube-NotoSans-Regular.otf");
                if (typeface != null) {
                    bulkTextView.setTypeface(typeface);
                }
                if (TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
                    this.bulkContainer.setVisibility(0);
                    FontUtil.setAllTextView((View)this.bulkContainer);
                    this.webview.loadUrl(String.format("http://%1$s.richnco-view.tenqube.kr/intro/", this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev")));
                    this.bulkContainer.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            VisualActivityFragment.this.signUp();
                        }
                    });
                } else {
                    this.resourceManager.sync();
                    this.alarmManager.setAlarms();
                    if (!TextUtils.isEmpty((CharSequence)this.path)) {
                        this.startPopup(this.path);
                    }
                    this.shouldShowNotiPopup = true;
                    this.loadUrl();
                }
            }
            catch (Exception e) {
                if (this.getActivity() == null) break block7;
                this.getActivity().finish();
            }
        }
    }

    private void signUp() {
        this.signUp(this.uid, new OnResultListener(){

            @Override
            public void onResult(final int signUpResult, String msg) {
                if (VisualActivityFragment.this.getActivity() != null) {
                    VisualActivityFragment.this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (signUpResult == 1) {
                                VisualActivityFragment.this.loadErrorUrl();
                            } else if (!VisualActivityFragment.this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
                                VisualActivityFragment.this.bulkParsingManager = new BulkParsingManagerImpl(VisualActivityFragment.this);
                                VisualActivityFragment.this.bulkParsingManager.start(new Callback<Boolean>(){

                                    @Override
                                    public void onComplete(Boolean value) {
                                        VisualActivityFragment.this.shouldShowNotiPopup = true;
                                        VisualActivityFragment.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
                                        VisualActivityFragment.this.loadUrl();
                                    }
                                });
                            } else {
                                VisualActivityFragment.this.shouldShowNotiPopup = true;
                                VisualActivityFragment.this.loadUrl();
                            }
                        }
                    });
                }
            }
        });
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getActivity() != null) {
            Utils.changeStatusColor((Activity)this.getActivity(), R.color.colorStatusBar);
        }
    }

    private void loadUrl() {
        this.bulkContainer.setVisibility(8);
        if (this.webview != null) {
            this.isPageLoaded = false;
            String url = WebViewHelper.getBaseUrl(this.prefManager);
            LogUtil.LOGI((String)TAG, (String)("loadUrl" + url), (boolean)ParserService.mIsDebug);
            this.webview.loadUrl(url);
        }
    }

    private void signUp(@NonNull String uid, final @NonNull OnResultListener onResultListener) {
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        final SignUpRequest signUpRequest = new SignUpRequest(uid);
        if (!TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            onResultListener.onResult(2, "already joined");
            return;
        }
        AnswerManager.onKeyMetric(new LogRequest("signUp"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SignUpResponse response = VisualActivityFragment.this.api.signUp(signUpRequest);
                    if (response == null) {
                        onResultListener.onResult(1, "network error");
                    } else {
                        VisualActivityFragment.this.repository.saveServerInfo(response);
                        onResultListener.onResult(0, "success");
                    }
                }
                catch (Exception e) {
                    onResultListener.onResult(1, e.toString());
                }
            }
        }).start();
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        this.errorView.setVisibility(0);
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.isPageLoaded = true;
                }
            });
        }
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        try {
            if (this.getActivity() != null) {
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        VisualActivityFragment.this.swipeRefreshLayout.setEnabled(enabled);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        if (this.getActivity() != null) {
            DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
            FragmentManager fragmentManager = this.getFragmentManager();
            if (fragmentManager != null) {
                fragmentManager.beginTransaction().add((Fragment)newFragment, "datePicker").commitAllowingStateLoss();
            }
        }
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        if (this.getActivity() != null) {
            TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
            FragmentManager fragmentManager = this.getFragmentManager();
            if (fragmentManager != null) {
                fragmentManager.beginTransaction().add((Fragment)newFragment, "timePicker").commitAllowingStateLoss();
            }
        }
    }

    @Override
    public void onFinish(String path) {
        if (this.getActivity() != null) {
            Intent intent = this.getActivity().getIntent();
            this.getActivity().setResult(TextUtils.isEmpty((CharSequence)path) || "false".equals(path) ? 0 : -1, intent);
            this.listener.onFragBackPressed();
        }
    }

    @Override
    public void startPopup(String path) {
        if (this.getActivity() != null) {
            Intent intent = new Intent((Context)this.getActivity(), VisualWebActivity.class);
            intent.putExtra(ARG_PATH, path);
            this.getActivity().startActivityForResult(intent, 1000);
        }
    }

    @Override
    public void showNotiCatch() {
        if (this.getActivity() != null) {
            NotificationDialogFragment dialogFragment = NotificationDialogFragment.newInstance();
            dialogFragment.setCallback(this);
            FragmentManager fragmentManager = this.getFragmentManager();
            if (fragmentManager != null && !dialogFragment.isAdded() && fragmentManager.findFragmentByTag(NotificationDialogFragment.TAG) == null) {
                fragmentManager.beginTransaction().add((Fragment)dialogFragment, NotificationDialogFragment.TAG).commitAllowingStateLoss();
            }
        }
    }

    @Override
    public void goNotiSettings() throws ActivityNotFoundException {
        if (this.getActivity() != null) {
            Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
            this.startActivityForResult(intent, 10);
        }
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.loadUrl(VisualActivityFragment.this.mFailingUrl);
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case 10: {
                    boolean isEnabled = Utils.isNotiEnabled((Context)this.getActivity());
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("isNotiEnabled", isEnabled);
                        String json = jsonObject.toString();
                        if (this.systemInterface != null) {
                            this.systemInterface.onNotiCallback(json);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1000: {
                    if (resultCode != -1) break;
                    this.reload();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                this.onFragBackPressed();
            }
        }
        catch (Exception e) {
            this.onFragBackPressed();
        }
    }

    public void onFragBackPressed() {
        if (this.listener != null) {
            this.listener.onFragBackPressed();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnFragBackListener)) {
            throw new RuntimeException(context.toString() + " must implement OnFragBackListener");
        }
        this.listener = (OnFragBackListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    @Override
    public void onOkButtonClicked() {
        this.goNotiSettings();
    }

    @Override
    public void onCancelButtonClicked() {
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> perms) {
        this.bulkParsingManager.onPermissionGranted();
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> perms) {
        this.bulkParsingManager.onPermissionsDenied();
    }

    public static interface OnFragBackListener {
        public void onFragBackPressed();
    }
}

