package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.NotificationApp;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;

import static com.tenqube.visual_third.util.FontUtil.setAllTextView;


public class NotiCatchDialogFragment extends DialogFragment {

    public static final String TAG = NotiCatchDialogFragment.class.getSimpleName();

    private AppAdapter appAdapter;
    private RecyclerView recyclerView;
    private VisualRepository repository;

    public NotiCatchDialogFragment() {
        super();
    }


    public static NotiCatchDialogFragment newInstance() {
        return new NotiCatchDialogFragment();
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(getActivity());
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_noti_catch,null);
            setAllTextView(view);

            repository = VisualRepository.getInstance(getActivity());

            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);

            recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
            appAdapter = new AppAdapter(Glide.with(getActivity()));
            recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            recyclerView.setAdapter(appAdapter);

            new LoadTask().execute();

            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
    }

    public class LoadTask extends AsyncTask<Void, Void, ArrayList<NotificationApp>> {

        @Override
        protected ArrayList<NotificationApp> doInBackground(Void... voids) {

            return repository.loadNotiCatchedApps();
        }

        @Override
        protected void onPostExecute(ArrayList<NotificationApp> notiCatches) {
            super.onPostExecute(notiCatches);
            appAdapter.addAll(notiCatches);
        }
    }

    public static class AppAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>  {

        ArrayList<NotificationApp> apps = new ArrayList<>();
        private final RequestManager requestManager;
        public AppAdapter(RequestManager requestManager) {
            this.requestManager = requestManager;
        }

        public void addAll(ArrayList<NotificationApp> smsList) {
            this.apps = smsList;
            notifyDataSetChanged();
        }

        @Override
        public NotiCatchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_noti, parent,false);
            return new NotiCatchViewHolder(v);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            NotificationApp notiCatch = apps.get(position);
            NotiCatchViewHolder notiCatchViewHolder = ((NotiCatchViewHolder)holder);
            requestManager.load(notiCatch.getImage()).into(notiCatchViewHolder.icon);
            notiCatchViewHolder.appName.setText(notiCatch.getName());

        }

        @Override
        public int getItemCount() {
            return apps == null ? 0 : apps.size();
        }

        public static class NotiCatchViewHolder extends RecyclerView.ViewHolder {

            private ImageView icon;
            private TextView appName;

            public NotiCatchViewHolder(View itemView) {
                super(itemView);
                icon = (ImageView)itemView.findViewById(R.id.icon);
                appName = (TextView)itemView.findViewById(R.id.app_name);

            }
        }
    }

}
