package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.lt;

public class TransactionRequest extends Request implements Serializable {

    private int year;
    private int month;
    private int before;
    private String callbackJS;

    private int dwType;
    private int exceptType;

    public TransactionRequest(int year, int month, int before, String callbackJS) {
        this.year = year;
        this.month = month;
        this.before = before;
        this.callbackJS = callbackJS;
    }

    public int getDwType() {
        return dwType;
    }

    public void setDwType(int dwType) {
        this.dwType = dwType;
    }


    public int getExceptType() {
        return exceptType;
    }

    public void setExceptType(int exceptType) {
        this.exceptType = exceptType;
    }

    public int getYear() {
        return year;
    }

    public int getMonth() {
        return month;
    }

    public int getBefore() {
        return before;
    }

    public String getCallbackJS() {
        return callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        gt(year, 2010);
        lt(month, 12);
        gt(month, 1);
        lt(before, 12);
        Validator.notNull(callbackJS);
    }
}
