/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.widget.DatePicker;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.Calendar;

public class DatePickerFragment
extends DialogFragment
implements DatePickerDialog.OnDateSetListener {
    private static final String ARG_CAL = "request";
    private Callback mListener;
    private Calendar calendar;
    private DateRequest dateRequest;

    public static DatePickerFragment newInstance(DateRequest dateRequest) {
        DatePickerFragment fragment = new DatePickerFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CAL, (Serializable)dateRequest);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.dateRequest = (DateRequest)this.getArguments().getSerializable(ARG_CAL);
            if (this.dateRequest != null) {
                this.calendar = Utils.toCalendarYMD(this.dateRequest.getDate());
            }
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5);
        DatePickerDialog dialog = new DatePickerDialog((Context)this.getActivity(), R.style.PickerTheme, (DatePickerDialog.OnDateSetListener)this, year, month, day);
        DatePicker datePicker = dialog.getDatePicker();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2018);
        calendar.set(2, 0);
        calendar.set(5, 1);
        datePicker.setMinDate(calendar.getTimeInMillis());
        calendar.set(1, year + 10);
        datePicker.setMaxDate(calendar.getTimeInMillis());
        return dialog;
    }

    public void onDateSet(DatePicker view, int year, int month, int day) {
        this.calendar.set(year, month, day);
        this.onCalendar(Utils.getYMD(this.calendar), this.dateRequest.getCallbackJS());
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof Callback)) {
            throw new RuntimeException(context.toString() + " must implement OnFragmentInteractionListener");
        }
        this.mListener = (Callback)context;
    }

    public void onCalendar(String date, String callback) {
        if (this.mListener != null) {
            this.mListener.onCalendar(date, callback);
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static interface Callback {
        public void onCalendar(String var1, String var2);
    }
}

