package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Calendar;

import static android.app.Activity.RESULT_CANCELED;
import static android.app.Activity.RESULT_OK;
import static com.tenqube.visual_third.manager.AnswerManager.initFabric;
import static com.tenqube.visual_third.manager.PrefManager.UID;
import static com.tenqube.visual_third.ui.VisualWebActivity.POPUP_CODE;
import static com.tenqube.visual_third.util.FontUtil.setAllTextView;
import static com.tenqube.visual_third.util.Utils.changeStatusColor;
import static com.tenqube.visual_third.util.Utils.isNotiEnabled;
import static com.tenqube.visual_third.util.WebViewHelper.getBaseUrl;
import static com.tenqube.visual_third.util.WebViewHelper.settings;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class VisualActivityFragment extends Fragment implements TimePickerFragment.Callback, DatePickerFragment.Callback, ViewContractor {

    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_UID = "UID";
    public static final String ARG_PATH = "PATH";

    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int NOTIFICATION_REQUEST_CODE = 10;

    private VisualRepository repository;
    private BulkLoader bulkLoader;
    private ResourceManager resourceManager;
    private PrefManager prefManager;
    private VisualAlarmManager alarmManager;
    private VisualApi api;
    private String mFailingUrl;
    private ProgressDialogFragment progressDialog;

    private WebView webview;

    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;

    private SwipeRefreshLayout swipeRefreshLayout;

    private boolean isPageLoaded;

    private OnFragBackListener listener;
    private FrameLayout bulkContainer;

    private ProgressBar progressBar;

    private String uid;
    private String path;

    public VisualActivityFragment() {
        // Required empty public constructor
    }

    public static VisualActivityFragment newInstance(String uid, String path) {

        VisualActivityFragment fragment = new VisualActivityFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_UID, uid);
        bundle.putString(ARG_PATH, path);

        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);

        if(getArguments() != null) {
            uid = getArguments().getString(ARG_UID, "");
            path = getArguments().getString(ARG_PATH, "");
        }
        LOGI(TAG, "Params(UID)" + uid, mIsDebug);
        LOGI(TAG, "Params(path)" + path, mIsDebug);

        api = VisualApi.getInstance(getActivity());
        prefManager = PrefManager.getInstance(getActivity());
        resourceManager = ResourceManager.getInstance(api, prefManager);
        repository = VisualRepository.getInstance(getActivity());
        alarmManager = VisualAlarmManager.getInstance(getActivity());
        initFabric(getActivity());
        AnswerManager.onKeyMetric(new LogRequest("VisualActivityFragment"));
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_visual_web, container, false);
        setAllTextView(view);
        return view;
    }

    @SuppressLint("AddJavascriptInterface")
    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            progressBar = (ProgressBar) view.findViewById(R.id.progress_bar);

            swipeRefreshLayout = (SwipeRefreshLayout) view.findViewById(R.id.swipe_refresh_layout);
            swipeRefreshLayout.setEnabled(false);
            swipeRefreshLayout.setColorSchemeResources(
                    R.color.colorPopupRed,
                    R.color.colorPopupRed,
                    R.color.colorPopupRed);

            swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
                @Override
                public void onRefresh() {
                    swipeRefreshLayout.setRefreshing(false);
                    webview.reload();
                }
            });

            webview = (WebView) view.findViewById(R.id.visual_web_view);
            webview.setBackgroundColor(ContextCompat.getColor(getActivity(), R.color.colorWebView));
            webview.getSettings().setTextZoom(100);//font size

            // javascriptInterface
            errorInterface = new ErrorImpl(getActivity(), this, webview);
            logInterface = new LogImpl(getActivity(), this, webview, errorInterface);
            repoInterface = new RepoImpl(getActivity(), this, webview, errorInterface,
                    VisualRepository.getInstance(getActivity()),
                    api,
                    new AnalysisServiceImpl(getActivity()),
                    alarmManager);

            uiInterface = new UiImpl(getActivity(), this, webview, errorInterface, new BottomDialog(getActivity()));
            systemInterface = new SystemImpl(getActivity(), this, webview, errorInterface);

            webview.addJavascriptInterface(errorInterface, "visualError");
            webview.addJavascriptInterface(repoInterface, "visualRepo");
            webview.addJavascriptInterface(uiInterface, "visualUI");
            webview.addJavascriptInterface(systemInterface, "visualSystem");
            webview.addJavascriptInterface(logInterface, "visualLog");

            // settings
            settings(webview);

            // error
            webview.setWebViewClient(new WebViewClient() {
                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    mFailingUrl = failingUrl;
                    progressBar.setVisibility(View.GONE);
                    loadErrorUrl();
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onPageCommitVisible(WebView view, String url) {
                    super.onPageCommitVisible(view, url);
                    progressBar.setVisibility(View.GONE);
                }


            });

            if(prefManager.loadStringValue(PrefManager.QUALIFIER, "dev").equals("dev"))
                webview.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);

            bulkContainer = (FrameLayout) view.findViewById(R.id.start_bulk);

            if(!prefManager.isEnabled(PrefManager.BULK_EXECUTED, false)) { // 벌크 파싱 진행

                bulkContainer.setVisibility(View.VISIBLE);
                TextView bulkTextView = view.findViewById(R.id.start_bulk_txt);
                if(bulkContainer != null) setAllTextView(bulkContainer);

                webview.loadUrl(String.format("http://%1$s.richnco-view.tenqube.kr/intro/", prefManager.loadStringValue(PrefManager.QUALIFIER, "dev")));

                bulkContainer.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        signUp(uid, new OnResultListener() {
                            @Override
                            public void onResult(final int signUpResult, final String msg) {

                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        if(signUpResult != Constants.SignupResult.FAIL) {
                                            startBulkParsing();
                                        } else {
                                            loadErrorUrl();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });

            } else {
                bulkContainer.setVisibility(View.GONE);

                // 리소스 동ㄱ화
                resourceManager.sync();

                // 웹 가계부 호출
                loadUrl();

                // 검색 실패 내역 다시 보내기
                syncSearchFailedTransactions();

                alarmManager.setAlarms();

                if(!TextUtils.isEmpty(path))
                    startPopup(path);
            }


        } catch(Exception e) {
            getActivity().finish();
        }
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        changeStatusColor(getActivity(), R.color.colorStatusBar);
    }

    private void loadUrl() {
        if(webview != null) {
            isPageLoaded = false;
            String url = getBaseUrl(prefManager);
            LOGI(TAG, "loadUrl" + url, mIsDebug);
            webview.loadUrl(url);
        }
    }

    private void signUp(@NonNull final String uid, @NonNull final OnResultListener onResultListener) {
        LOGI(TAG, "가입", mIsDebug);

            final SignUpRequest signUpRequest = new SignUpRequest(uid);

            if(!TextUtils.isEmpty(prefManager.loadStringValue(UID, ""))) {
                onResultListener.onResult(Constants.SignupResult.ALREADY_JOINED, "already joined");
                return;
            }

            AnswerManager.onKeyMetric(new LogRequest("signUp"));
            new Thread(new Runnable() {
                @Override
                public void run() {

                    try {
                        SignUpResponse response = api.signUp(signUpRequest);

                        if (response == null) {
                            onResultListener.onResult(Constants.SignupResult.FAIL, "network error");
                        } else {

                            // login request succeed, new token generated
                            prefManager.saveStringValue(PrefManager.SEARCH_URL, response.getResults().getSearch().getUrl());
                            prefManager.saveStringValue(PrefManager.SEARCH_API_KEY, response.getResults().getSearch().getApiKey());
                            prefManager.saveStringValue(UID, response.getResults().getAuthorization().getSdk());
                            prefManager.saveLongValue(PrefManager.SIGN_UP_TIME, Calendar.getInstance().getTimeInMillis());
                            if (response.getResults().getWeb() != null)
                                prefManager.saveStringValue(PrefManager.WEB_URL, response.getResults().getWeb().getUrl());

                            onResultListener.onResult(Constants.SignupResult.SUCCESS, "success");
                        }
                    } catch (Exception e) {
                        onResultListener.onResult(Constants.SignupResult.FAIL, e.toString());
                    }
                }
            }).start();

    }

    private void loadErrorUrl() {
        isPageLoaded = false;
        if(swipeRefreshLayout != null) swipeRefreshLayout.setEnabled(false);
        if(webview != null) webview.loadUrl("file:///android_asset/index.html");
    }

    /**
     * 검색 실패 내역 다시 보내기
     */
    private void syncSearchFailedTransactions() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                SearchCompanyRequest request = repository.loadFailedSearchTransactions();

                if(request != null) api.searchCompany(request);

                api.syncTransactions(null);
            }
        }).start();

    }

    private Handler handler = new Handler(new Handler.Callback() { // 핸들러로 전달받은 값 progress 값 세팅해주기
        @Override
        public boolean handleMessage(final Message msg) {

            try {
                switch (msg.what) {
                    case PROGRESS:
                        if(progressDialog != null && progressDialog.isAdded()) {
                            Bundle bundle = msg.getData();
                            if(bundle != null) {
                                progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                            }
                        }
                        break;

                    case SHOW_PROGRESS_BAR:

                        try {
                            if(progressDialog == null) {
                                progressDialog = ProgressDialogFragment.newInstance(getActivity());
                                progressDialog.setCancelable(false);
                            }

                            if(!progressDialog.isAdded()) {
                                FragmentManager fragmentManager = getActivity().getSupportFragmentManager();
                                progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                            }

                        } catch (Exception e) {
                            progressDialog = null;
                        }
                        break;
                    case FINISH:
                    case ERROR:
                    default:
                        onBulkFinished();
                        break;
                }
            } catch (Exception e) {
                onBulkFinished();
            }

            return false;
        }
    });

    private void onBulkFinished() {
        try {
            prefManager.saveBoolean(PrefManager.BULK_EXECUTED, true);
            if(progressDialog != null && progressDialog.isAdded()) progressDialog.dismissAllowingStateLoss();
            // 딜레이 추가
            bulkContainer.setVisibility(View.GONE);
            loadUrl();
            alarmManager.setAlarms();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 1. 퍼미션 체크
     * 2. 프로그레스 다이얼로그 show
     * 3. 지난 6개월 문자 파싱 시작
     */
    private void startBulkParsing() {
        LOGI(TAG, "벌크 파싱 진행", mIsDebug);
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {

                    LOGI(TAG, "startBulkParsing start", mIsDebug);
                    bulkLoader = new BulkLoader(getActivity(), handler, new BulkLoader.OnSmsLoadFinished() {
                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if(handler != null) handler.sendEmptyMessage(FINISH);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    // 2. 프로그레스 다이얼로그 show
                    LOGI(TAG, "2. 프로그레스 다이얼로그 show", mIsDebug);
                    handler.sendEmptyMessage(SHOW_PROGRESS_BAR);

                    // 3. 지난 6개월 문자 파싱 시작
                    LOGI(TAG, "3. 지난 6개월 문자 파싱 시작", mIsDebug);
                    bulkLoader.doParsing();

                } catch (Exception e) {
                    handler.sendEmptyMessage(ERROR);
                }

            }
        }).start();
    }

    @Override
    public void onCalendar(String date, String callback) {
        uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                isPageLoaded = true;
            }
        });
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        swipeRefreshLayout.post(new Runnable() {
            @Override
            public void run() {
                swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        DialogFragment newFragment = DatePickerFragment.newInstance(dateRequest);
        newFragment.show(getActivity().getSupportFragmentManager(), "datePicker");
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        DialogFragment newFragment = TimePickerFragment.newInstance(timeRequest);
        newFragment.show(getActivity().getSupportFragmentManager(), "timePicker");
    }

    @Override
    public void onFinish(String path) {

        Intent intent = getActivity().getIntent();
        getActivity().setResult(TextUtils.isEmpty(path) || "false".equals(path) ?
                RESULT_CANCELED
                :
                RESULT_OK, intent);

        listener.onFragBackPressed();
    }

    @Override
    public void startPopup(String path) {
        Intent intent = new Intent(getActivity(), VisualWebActivity.class);
        intent.putExtra(VisualWebActivity.ARG_PATH, path);
        getActivity().startActivityForResult(intent, POPUP_CODE);
    }

    @Override
    public void showNotiCatch() {
        NotiCatchDialogFragment notiCatchDialogFragment = NotiCatchDialogFragment.newInstance();

        if(!notiCatchDialogFragment.isAdded()) {
            FragmentManager fragmentManager = getActivity().getSupportFragmentManager();
            notiCatchDialogFragment.show(fragmentManager, NotiCatchDialogFragment.TAG);
        }
    }

    @Override
    public void goNotiSettings() throws ActivityNotFoundException {
        Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        getActivity().startActivityForResult(intent, NOTIFICATION_REQUEST_CODE);
    }

    @Override
    public void reload() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.loadUrl(mFailingUrl);
                }
            });
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {

        switch (requestCode) {
            case NOTIFICATION_REQUEST_CODE:
                boolean isEnabled = isNotiEnabled(getActivity());

                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if(systemInterface != null) systemInterface.onNotiCallback(json);

                } catch (JSONException e) {
                    e.printStackTrace();
                }
                break;

            case POPUP_CODE:
                if(resultCode == RESULT_OK) {
                    reload();
                }
                break;
        }

    }

    public void onBackPressed() {
        try {
            if(isPageLoaded && uiInterface != null) {
                uiInterface.onFinish();
            } else {
                onFragBackPressed();
            }
        } catch (Exception e) {
            onFragBackPressed();
        }
    }

    public void onFragBackPressed() {
        if(listener != null) listener.onFragBackPressed();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof VisualActivityFragment.OnFragBackListener) {
            listener = (VisualActivityFragment.OnFragBackListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragBackListener");
        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        listener = null;
    }

    public interface OnFragBackListener {
        void onFragBackPressed();
    }

}
