/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.executor;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.Nullable;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.parser.executor.BulkCallback;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.util.Utils;

public class BulkExecutor {
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int SYNC_ERROR = 14;
    public static final int SHOW_SYNC_PROGRESS_BAR = 16;
    public static final int CLOSE_SYNC_PROGRESS_BAR = 17;
    private static BulkExecutor instance;
    private Context context;
    private BulkLoader bulkLoader;
    @Nullable
    private BulkCallback callback;
    public boolean isLoading;
    private Constants.ProgressType progressType = Constants.ProgressType.BULK;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Utils.LOGD("bulkExecutor", "PROGRESS");
                        Bundle bundle = msg.getData();
                        if (bundle != null && BulkExecutor.this.callback != null) {
                            BulkExecutor.this.callback.onProgress(bundle.getInt("now"), bundle.getInt("total"));
                        }
                        break;
                    }
                    case 12: {
                        BulkExecutor.this.isLoading = true;
                        BulkExecutor.this.progressType = Constants.ProgressType.BULK;
                        if (BulkExecutor.this.callback != null) {
                            BulkExecutor.this.callback.loadProgressUrl(Constants.ProgressType.BULK);
                        }
                        Utils.LOGD("BulkHandler", "startBulk handleMessage SHOW_PROGRESS_BAR");
                        break;
                    }
                    case 16: {
                        BulkExecutor.this.progressType = Constants.ProgressType.SYNC;
                        if (BulkExecutor.this.callback != null) {
                            BulkExecutor.this.callback.loadProgressUrl(Constants.ProgressType.SYNC);
                        }
                        BulkExecutor.this.isLoading = true;
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 14: {
                        Utils.LOGD("BulkHandler", "onBulkFinish SYNC_ERROR");
                        BulkExecutor.this.onSyncError();
                        BulkExecutor.this.onBulkFinish(false, false);
                        break;
                    }
                    case 10: {
                        Utils.LOGD("BulkHandler", "onBulkFinish FINISH");
                        BulkExecutor.this.onBulkFinish(true, true);
                        break;
                    }
                    default: {
                        Utils.LOGD("BulkHandler", "onBulkFinish DEFAULT " + msg.what);
                        BulkExecutor.this.onBulkFinish(false, true);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Utils.LOGD("BulkHandler", "Exception  " + e.toString());
                BulkExecutor.this.onBulkFinish(false, true);
            }
            return false;
        }
    });

    private BulkExecutor(Context context) {
        this.context = context;
    }

    public static BulkExecutor getInstance(Context context) {
        if (instance == null) {
            instance = new BulkExecutor(context);
        }
        return instance;
    }

    public void setCallback(BulkCallback callback) {
        this.callback = callback;
    }

    public void start(final boolean isInit) {
        Utils.LOGD("bulkExecutor", "startisInit" + isInit);
        Utils.LOGD("bulkExecutor", "startisLoading" + this.isLoading);
        if (!this.isLoading) {
            this.isLoading = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (isInit) {
                            BulkExecutor.this.handler.sendEmptyMessage(16);
                        } else {
                            BulkExecutor.this.handler.sendEmptyMessage(12);
                        }
                        BulkExecutor.this.bulkLoader = new BulkLoader(BulkExecutor.this.context, BulkExecutor.this.handler);
                        BulkExecutor.this.bulkLoader.doParsing(isInit);
                    }
                    catch (Exception e) {
                        BulkExecutor.this.handler.sendEmptyMessage(13);
                    }
                }
            }).start();
        } else if (this.callback != null) {
            this.callback.loadProgressUrl(this.progressType);
        }
    }

    private void onSyncError() {
        Utils.LOGD("onSyncError", "start");
        if (this.callback != null) {
            this.callback.onSyncError();
        }
    }

    private void onBulkFinish(boolean isSuccess, boolean shouldReload) {
        Utils.LOGD("bulkExecutor", "onBulkFinish");
        this.isLoading = false;
        if (this.callback != null) {
            this.callback.onBulkFinish(isSuccess, shouldReload);
        }
        this.destroy();
    }

    private void destroy() {
        Utils.LOGD("bulkExecutor", "destroy");
        instance = null;
        this.bulkLoader = null;
        this.callback = null;
        this.handler = null;
    }
}

