/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Log;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Card;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.InsertTransactionRequest;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.model.parser.MigrationCard;
import com.tenqube.visual_third.model.parser.SyncTransaction;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.List;
import tenqube.parser.constants.Constants;

public class TransactionDao {
    private final Db db;

    public TransactionDao(Db db) {
        this.db = db;
    }

    public Cursor getSum(String fromAt, String toAt, int groupBy) {
        String query = QueryGenerator.sum(fromAt, toAt, groupBy);
        try {
            return this.db.runQuery(query);
        }
        catch (SQLiteException sQLiteException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSum(String fromAt, String toAt) {
        String query = QueryGenerator.sum();
        try (Cursor c = null;){
            String[] args = new String[]{fromAt, toAt};
            c = this.db.runQuery(query, args);
            if (c != null && c.moveToFirst()) {
                double d = c.getDouble(0);
                return d;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadTranId(String identifier) {
        String query = QueryGenerator.tranId();
        try (Cursor c = null;){
            c = this.db.runQuery(query, new String[]{identifier});
            if (c != null && c.moveToFirst()) {
                int n = c.getInt(0);
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> loadDeletedTranIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String query = QueryGenerator.deletedTranIds();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    ids.add(c.getInt(0));
                    c.moveToNext();
                }
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction loadApplyAllTran(String keyword) {
        String query = QueryGenerator.applyAllTran();
        try (Cursor c = null;){
            c = this.db.runQuery(query, new String[]{keyword});
            if (c != null && c.moveToFirst()) {
                Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                return transaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinedTransaction loadJoinedTransaction(int tranId) {
        String query = QueryGenerator.joinedTransaction();
        try (Cursor c = null;){
            c = this.db.runQuery(query, new String[]{tranId + ""});
            if (c != null && c.moveToFirst()) {
                Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                Card card = ReaderContract.CardTable.populateModel(c);
                Category category = ReaderContract.CategoryTable.populateModel(c);
                JoinedTransaction joinedTransaction = new JoinedTransaction(transaction, card, userCategory, category);
                return joinedTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JoinedTransaction> loadJoinedTransactions(TransactionRequest transactionRequest) {
        String query = QueryGenerator.joinedTransaction(transactionRequest);
        ArrayList<JoinedTransaction> results = new ArrayList<JoinedTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                    Card card = ReaderContract.CardTable.populateModel(c);
                    Category category = ReaderContract.CategoryTable.populateModel(c);
                    results.add(new JoinedTransaction(transaction, card, userCategory, category));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JoinedTransaction> loadJoinedTransactions(TransactionByIdsRequest transactionRequest) {
        String query = QueryGenerator.joinedTransaction(transactionRequest);
        ArrayList<JoinedTransaction> results = new ArrayList<JoinedTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                    Card card = ReaderContract.CardTable.populateModel(c);
                    Category category = ReaderContract.CategoryTable.populateModel(c);
                    results.add(new JoinedTransaction(transaction, card, userCategory, category));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JoinedTransaction> loadNotSyncedTransactions() {
        String query = QueryGenerator.notSyncedTransactions();
        ArrayList<JoinedTransaction> results = new ArrayList<JoinedTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                    Card card = ReaderContract.CardTable.populateModel(c);
                    Category category = ReaderContract.CategoryTable.populateModel(c);
                    results.add(new JoinedTransaction(transaction, card, userCategory, category));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JoinedTransaction> loadJoinedTransactions() {
        String query = QueryGenerator.allTransactions();
        ArrayList<JoinedTransaction> results = new ArrayList<JoinedTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                    Card card = ReaderContract.CardTable.populateModel(c);
                    Category category = ReaderContract.CategoryTable.populateModel(c);
                    results.add(new JoinedTransaction(transaction, card, userCategory, category));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> findTransactionIdsByCardIds(List<Integer> cardIds) {
        String query = QueryGenerator.transactionByCardIds(cardIds);
        ArrayList<Integer> results = new ArrayList<Integer>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    results.add(transaction.getId());
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JoinedTransaction> loadFailedSearchTransactions() {
        String query = QueryGenerator.failedSearchTransaction();
        ArrayList<JoinedTransaction> results = new ArrayList<JoinedTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Transaction transaction = ReaderContract.TransactionsTable.populateModel(c);
                    Card card = ReaderContract.CardTable.populateModel(c);
                    results.add(new JoinedTransaction(transaction, card, null, null));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void mergeTransaction(com.tenqube.visual_third.model.parser.Transaction transaction) {
        try {
            ContentValues values = new ContentValues();
            values.put("identifier", transaction.getParsedTransaction().identifier);
            values.put("cardId", Integer.valueOf(transaction.getCardId()));
            values.put("userCategoryId", Integer.valueOf(transaction.getUserCateId()));
            values.put("categoryCode", transaction.getCategoryCode());
            values.put("spentDate", transaction.getParsedTransaction().spentDate);
            values.put("finishDate", transaction.getParsedTransaction().finishDate);
            values.put("spentLatitude", Double.valueOf(transaction.getParsedTransaction().spentLatitude));
            values.put("spentLongitude", Double.valueOf(transaction.getParsedTransaction().spentLongitude));
            values.put("spentMoney", Double.valueOf(transaction.getSpentMoney()));
            values.put("oriSpentMoney", Double.valueOf(transaction.getParsedTransaction().spentMoney));
            values.put("installmentCount", Integer.valueOf(transaction.getParsedTransaction().installmentCount));
            values.put("keyword", transaction.getParsedTransaction().keyword.replace("\u321c", "(\uc8fc)"));
            values.put("searchKeyword", transaction.getParsedTransaction().keyword.replace("\u321c", "(\uc8fc)"));
            values.put("repeatType", Integer.valueOf(0));
            values.put("currency", transaction.getParsedTransaction().currency);
            values.put("dwType", Integer.valueOf(transaction.getParsedTransaction().dwType));
            values.put("sender", transaction.getParsedTransaction().sender);
            values.put("fullSms", "");
            values.put("smsDate", transaction.getParsedTransaction().smsDate);
            values.put("smsType", Integer.valueOf(transaction.getParsedTransaction().smsType));
            values.put("regId", Integer.valueOf(transaction.getParsedTransaction().regId));
            values.put("isOffset", Integer.valueOf(transaction.getParsedTransaction().isOffset));
            values.put("memo", transaction.getParsedTransaction().memo);
            this.db.insertOnReplace(" TRANSACTIONS", values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int insertTransaction(InsertTransactionRequest insertTran) {
        try {
            ContentValues values = new ContentValues();
            values.put("userCategoryId", Integer.valueOf(insertTran.getCateConfigId()));
            values.put("identifier", Utils.getIdentifier());
            values.put("smsDate", insertTran.getDate());
            values.put("smsType", Integer.valueOf(Constants.SMSType.SMS.ordinal()));
            values.put("keyword", insertTran.getKeyword());
            values.put("spentMoney", Double.valueOf(insertTran.getAmount()));
            values.put("cardId", Integer.valueOf(insertTran.getCardId()));
            values.put("installmentCount", Integer.valueOf(insertTran.getInstallmentCnt()));
            values.put("spentDate", insertTran.getDate());
            values.put("memo", insertTran.getMemo());
            values.put("isCustom", Integer.valueOf(1));
            values.put("dwType", Integer.valueOf(insertTran.isExpense() ? Constants.DWType.WITHDRAW.ordinal() : Constants.DWType.DEPOSIT.ordinal()));
            values.put("isSynced", Integer.valueOf(0));
            String categoryCode = String.valueOf(insertTran.getlCode()) + String.valueOf(insertTran.getmCode()) + "10";
            values.put("categoryCode", categoryCode);
            long row = this.db.insert(" TRANSACTIONS", values);
            return (int)row;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int insertTransaction(SyncTransaction syncTransaction, int cardId, int userCateId) {
        try {
            ContentValues values = new ContentValues();
            values.put("identifier", syncTransaction.identifier);
            values.put("finishDate", syncTransaction.finishDate);
            values.put("spentLatitude", Integer.valueOf(-1));
            values.put("spentLongitude", Integer.valueOf(-1));
            values.put("repeatType", Integer.valueOf(0));
            values.put("currency", syncTransaction.currency);
            values.put("sender", syncTransaction.sender);
            values.put("fullSms", "");
            values.put("isOffset", Integer.valueOf(syncTransaction.isOffset));
            values.put("userCategoryId", Integer.valueOf(userCateId));
            values.put("keyword", syncTransaction.keyword);
            values.put("oriSpentMoney", Double.valueOf(syncTransaction.oriSpentMoney));
            values.put("spentMoney", Double.valueOf(syncTransaction.spentMoney));
            values.put("cardId", Integer.valueOf(cardId));
            values.put("installmentCount", Integer.valueOf(syncTransaction.installmentCount));
            values.put("spentDate", syncTransaction.spentDate);
            values.put("isCustom", Integer.valueOf(syncTransaction.isCustom));
            values.put("dwType", Integer.valueOf(syncTransaction.dwType));
            values.put("isSynced", Integer.valueOf(1));
            values.put("categoryCode", Integer.valueOf(syncTransaction.categoryCode));
            long row = this.db.insertOnReplace(" TRANSACTIONS", values);
            Utils.LOGD("insertTransaction", "row : " + row);
            Utils.LOGD("insertTransaction", "identifier : " + syncTransaction.identifier);
            Utils.LOGD("insertTransaction", "spentDate: " + syncTransaction.spentDate);
            Utils.LOGD("insertTransaction", "values : " + values.toString());
            return (int)row;
        }
        catch (Exception e) {
            Utils.LOGD("insertTransaction", "iException: " + e.toString());
            return 0;
        }
    }

    public void updateSyncedTransactions(ArrayList<String> ids) {
        try {
            ContentValues values = new ContentValues();
            values.put("isSynced", Integer.valueOf(1));
            this.db.update(" TRANSACTIONS", values, "identifier IN (" + TextUtils.join((CharSequence)",", ids) + ")", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateRetryTransactions(ArrayList<String> ids, boolean shouldRetry) {
        try {
            ContentValues values = new ContentValues();
            values.put("shouldRetrySearch", Integer.valueOf(shouldRetry ? 1 : 0));
            if (shouldRetry) {
                values.put("isSynced", Integer.valueOf(0));
            }
            this.db.update(" TRANSACTIONS", values, "identifier IN (" + TextUtils.join((CharSequence)",", ids) + ")", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTransactionCard(MigrationCard card) {
        try {
            ContentValues values = new ContentValues();
            values.put("cardId", Integer.valueOf(card.cardId));
            long row = this.db.update(" TRANSACTIONS", values, "identifier= " + card.identifier, null);
            Utils.LOGD("updateTransactionCard", "row" + row);
        }
        catch (Exception e) {
            Utils.LOGD("updateTransactionCard", "e" + e);
        }
    }

    public void updateTransaction(UpdateTransactionRequest updateTran) {
        try {
            ContentValues values = new ContentValues();
            values.put("userCategoryId", Integer.valueOf(updateTran.getCateConfigId()));
            values.put("keyword", updateTran.getKeyword());
            values.put("spentMoney", Double.valueOf(updateTran.getAmount()));
            values.put("cardId", Integer.valueOf(updateTran.getCardId()));
            values.put("installmentCount", Integer.valueOf(updateTran.getInstallmentCnt()));
            values.put("spentDate", updateTran.getDate());
            values.put("memo", updateTran.getMemo());
            values.put("dwType", Integer.valueOf(updateTran.isExpense() ? Constants.DWType.WITHDRAW.ordinal() : Constants.DWType.DEPOSIT.ordinal()));
            values.put("isUpdateAll", Integer.valueOf(updateTran.isAll() ? 1 : 0));
            values.put("isSynced", Integer.valueOf(0));
            String categoryCode = String.valueOf(updateTran.getlCode()) + String.valueOf(updateTran.getmCode()) + "10";
            values.put("categoryCode", categoryCode);
            long row = this.db.update(" TRANSACTIONS", values, "tranId= " + updateTran.getTranId(), null);
            Log.i((String)"tag", (String)(row + ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTransaction(SearchCompanyResponse.TranCompany tranCompany, int userCateId) {
        try {
            ContentValues values = new ContentValues();
            values.put("userCategoryId", Integer.valueOf(userCateId));
            values.put("categoryCode", tranCompany.getCategory().getCode());
            values.put("franchise", tranCompany.getCompany().getName());
            values.put("companyId", Integer.valueOf(tranCompany.getCompany().getId()));
            values.put("classCode", tranCompany.getClassCode());
            values.put("searchKeyword", tranCompany.getKeyword().getSearch());
            values.put("keyword", tranCompany.getKeyword().getOri());
            this.db.update(" TRANSACTIONS", values, "identifier= ?", new String[]{tranCompany.getIdentifier() + ""});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTransactionByKeyword(SearchCompanyResponse.TranCompany tranCompany, int userCateId) {
        try {
            ContentValues values = new ContentValues();
            values.put("userCategoryId", Integer.valueOf(userCateId));
            values.put("categoryCode", tranCompany.getCategory().getCode());
            values.put("franchise", tranCompany.getCompany().getName());
            values.put("companyId", Integer.valueOf(tranCompany.getCompany().getId()));
            if (!TextUtils.isEmpty((CharSequence)tranCompany.getClassCode())) {
                values.put("classCode", tranCompany.getClassCode());
            }
            values.put("searchKeyword", tranCompany.getKeyword().getSearch());
            values.put("keyword", tranCompany.getKeyword().getOri());
            this.db.update(" TRANSACTIONS", values, "keyword= ?", new String[]{tranCompany.getKeyword().getOri()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateDeletedTransactionById(Integer[] ids) {
        try {
            ContentValues values = new ContentValues();
            values.put("isDeleted", Integer.valueOf(1));
            values.put("isSynced", Integer.valueOf(0));
            String selection = "tranId IN (" + TextUtils.join((CharSequence)",", (Object[])ids) + ") ";
            this.db.update(" TRANSACTIONS", values, selection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateDeletedTransactions() {
        try {
            ContentValues values = new ContentValues();
            values.put("isDeleted", Integer.valueOf(1));
            values.put("isSynced", Integer.valueOf(0));
            this.db.update(" TRANSACTIONS", values, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteTransactions(ArrayList<Integer> ids) {
        try {
            String selection = "tranId IN (" + TextUtils.join((CharSequence)",", ids) + ") ";
            this.db.delete(" TRANSACTIONS", selection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

