package com.tenqube.visual_third.util;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;

import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.FileProvider;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.gson.Gson;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

import static com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo;
import static com.tenqube.visual_third.Constants.FROM;
import static com.tenqube.visual_third.Constants.LCODE.ALCOHOL;
import static com.tenqube.visual_third.Constants.LCODE.BEAUTY;
import static com.tenqube.visual_third.Constants.LCODE.CAFE;
import static com.tenqube.visual_third.Constants.LCODE.CULTURE;
import static com.tenqube.visual_third.Constants.LCODE.DEPOSIT_ETC;
import static com.tenqube.visual_third.Constants.LCODE.DEPOSIT_LOAN;
import static com.tenqube.visual_third.Constants.LCODE.DEPOSIT_MOVING_ASSET;
import static com.tenqube.visual_third.Constants.LCODE.EDUCATION;
import static com.tenqube.visual_third.Constants.LCODE.FAMILY_EVENT;
import static com.tenqube.visual_third.Constants.LCODE.FINANCE;
import static com.tenqube.visual_third.Constants.LCODE.FOOD;
import static com.tenqube.visual_third.Constants.LCODE.HEALTHCARE;
import static com.tenqube.visual_third.Constants.LCODE.INCOME_MAIN;
import static com.tenqube.visual_third.Constants.LCODE.INCOME_SUB;
import static com.tenqube.visual_third.Constants.LCODE.LEPORTS;
import static com.tenqube.visual_third.Constants.LCODE.LIVINGS;
import static com.tenqube.visual_third.Constants.LCODE.MART;
import static com.tenqube.visual_third.Constants.LCODE.ONLINE;
import static com.tenqube.visual_third.Constants.LCODE.SHOPPING;
import static com.tenqube.visual_third.Constants.LCODE.TRANSPORT;
import static com.tenqube.visual_third.Constants.LCODE.TRAVEL;
import static com.tenqube.visual_third.Constants.LCODE.UNCATE;
import static com.tenqube.visual_third.Constants.LCODE.WITHDRAW_CODE;
import static com.tenqube.visual_third.Constants.LCODE.WITHDRAW_MOVING_ASSET;
import static com.tenqube.visual_third.Constants.TO;
import static com.tenqube.visual_third.Constants.VISUAL_TAG;
import static com.tenqube.visual_third.Constants.sLogger;

public class Utils {

    public static final SimpleDateFormat timeDf = new SimpleDateFormat("HH:mm:ss", Locale.KOREA);
    public static final SimpleDateFormat ymdDF = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
    public static final SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);

    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");// decimalformat은
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static double sumBy(ArrayList<Transaction> transactions) {
        double sum = 0;
        for(Transaction d : transactions)
            sum += d.getTransaction().getSpentMoney();
        return sum;
    }

    public static void LOGD(String function, String message) {
        if (sLogger) {
            Log.d(VISUAL_TAG, "function:" + function + "\nmessage: " + message);
        }
    }

    public static InputStream toInputStream(Object data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(data);
        oos.flush();
        oos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static String getApplicationName(Context context) {

        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        } catch (Exception e) {
            return "해당 앱";
        }

    }

    public static String makeDialogPath(int tranId, String keyword, String lCategory, String mCategory, String lCode, String mCode, String spentDate, double amount, int installmentCnt, int cardId, String memo, String dwType, String prevPage) {
        return String.format(Locale.KOREA, "&id=%1$d&keyword=%2$s&lCategory=%3$s&mCategory=%4$s&lCode=%5$s&mCode=%6$s&date=%7$s&amount=%8$f&installmentCnt=%9$d&cardId=%10$d&memo=%11$s&dwType=%12$s&prevPage=%13$s",
                tranId, keyword, lCategory, mCategory, lCode, mCode, spentDate, amount, installmentCnt, cardId, memo, dwType, prevPage);
    }

    public static Uri getUri(Context context, String authority, File file) throws Exception {
        if(Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile(context.getApplicationContext(), authority, file);
        } else {
            return Uri.fromFile(file);
        }
    }

    public static Long getIdentifier() {

        String prefix = Math.abs(UUID.randomUUID().toString().hashCode()) + "";
        String postfix = System.nanoTime() + "";
        try {
            String identifier = prefix.substring(0, 3) + postfix.substring(postfix.length() - 10);
            return Long.parseLong(identifier);
        } catch (Exception e) {
            return System.currentTimeMillis();
        }
    }

    public static String getAdId(Context context) {
        try {

            AdvertisingIdClient.Info info = getAdvertisingIdInfo(context);
            if(info != null && !info.isLimitAdTrackingEnabled()) {
                return info.getId();
            }
        } catch (Exception e) {
            return null;
        }

        return null;

    }

    public static boolean isSDKDisabled(Context context) {
        try {
            boolean isEnabled = PrefManager.getInstance(context).isEnabled(PrefManager.SDK_ENABLED, true);
            boolean isAuth = !TextUtils.isEmpty(SecretKeyManager.getInstance(context).getKey(PrefManager.ACCESS_TOKEN));

            return !(isEnabled && isAuth);
        } catch (Exception e) {
            return false;
        }

    }

    public static <T> boolean isEmpty(ArrayList<T> list) {
        return list == null || list.size() == 0;
    }

    public static  <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        return new Gson().toJson(object);
    }

    public static boolean shouldParsing(String msg) {

        int cnt = 0;

        if(TextUtils.isEmpty(msg)) return false;

        if(msg.contains("원")) ++cnt;

        if(msg.contains(".")) ++cnt;

        if(msg.contains(",")) ++cnt;

        if(cnt == 3) return true;

        if(msg.contains("/")) ++cnt;

        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return getStringDateAsYYYYMMddHHmmss(cal);
    }


    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {

        try {
            if (cal == null) cal = Calendar.getInstance();

            return cal.get(Calendar.YEAR) + "-" +
                    DECIMAL_FORMAT.format((cal.get(Calendar.MONTH) + 1)) + "-" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.DATE)) + " " +
                    DECIMAL_FORMAT.format(cal.get(Calendar.HOUR_OF_DAY)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.MINUTE)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.SECOND));
        } catch (Exception e) {

        }

        return "";
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long) value) + "원";
    }

    public static String convertKeyword(String keyword, int dwType) {
//        if("내용없음".equals(keyword)) {
//            if(dwType == Constants.DWType.WITHDRAW.ordinal()) {
//                return "출금";
//            } else {
//                return "입금";
//            }
//        }
        return keyword;
    }

//    /**
//     *  파라미터로 해당 년, 월의 데이터와 'before' 이전의 데이터의 기간을 설정합니다. 예를 들면 2018년 5월 부터 2018년 8월까지의 데이터를 호출하려면
//     * @param year 해당 년
//     * @param month 해당 월
//     * @param before 개월수
//     * @return
//     */
//    public static String[] getDateRange(int year, int month, int before, int startDay) {//시작일 구하기0
//        //2015 -5 5 6 4   오늘은 6 4
//
//        String[] dates = new String[2];
//        String startDateStr;
//        String resultEndDate;
//        String resultEndDatePlusOne;
//        Calendar startCal = Calendar.getInstance();
//        startCal.set(Calendar.YEAR, year);
//        startCal.set(Calendar.MONTH, month - 1);
//
//        Calendar todayCal = Calendar.getInstance();
//
//        //시작일 구하기
//        int posTemp = -1 * before;
//
//        if (todayCal.get(Calendar.DATE) < startDay) {
//            startCal.add(Calendar.MONTH, posTemp - 1); //2015 6 4
//        } else {
//            startCal.add(Calendar.MONTH, posTemp); //2015 6 4
//        }
//
//        int currentYear = startCal.get(Calendar.YEAR); //2015
//        int currentMonth = startCal.get(Calendar.MONTH);//2015
//        int actualDay = startCal.getActualMaximum(Calendar.DATE);//30
//
//
//        if (actualDay > startDay) { //30> 1
//            startDateStr =
//                    currentYear + "-" +
//                            DECIMAL_FORMAT.format((currentMonth + 1)) + "-" +
//                            DECIMAL_FORMAT.format(startDay);
//        } else {//30,31
//            startDateStr =
//                    currentYear + "-" +
//                            DECIMAL_FORMAT.format((currentMonth + 1)) + "-" +
//                            DECIMAL_FORMAT.format(actualDay);
//        }
//        dates[FROM] = "" +  startDateStr + " 00:00:00";
//
//
//
//        Calendar endCal = Calendar.getInstance(); //2015 6 4
//        endCal.set(Calendar.YEAR, year);
//        endCal.set(Calendar.MONTH, month - 1);
//
//
//        // 마지막일 구하기
//        if (todayCal.get(Calendar.DATE) >= startDay) {
//            endCal.add(Calendar.MONTH, 1); //2015 7
//        }
//
//        currentYear = endCal.get(Calendar.YEAR);//2015
//        currentMonth = endCal.get(Calendar.MONTH);
//        actualDay = endCal.getActualMaximum(Calendar.DATE);
//
//        if (actualDay > startDay) {
//            endCal.set(currentYear, currentMonth, startDay);
//        } else {
//            endCal.set(currentYear, currentMonth, actualDay);
//        }
//
//        endCal.add(Calendar.DATE, -1);
//
////        resultEndDate =
////                endCal.get(Calendar.YEAR) + "-" +
////                        DECIMAL_FORMAT.format((endCal.get(Calendar.MONTH) + 1)) + "-" +
////                        DECIMAL_FORMAT.format(endCal.get(Calendar.DATE));
//
//        // 마지막일 구하기 +1 오늘 날짜인경우
//        if (compareDate(todayCal, endCal)) {
//
//            todayCal.add(Calendar.DATE, 1);
//            resultEndDatePlusOne =
//                    todayCal.get(Calendar.YEAR) + "-" +
//                            DECIMAL_FORMAT.format((todayCal.get(Calendar.MONTH) + 1)) + "-" +
//                            DECIMAL_FORMAT.format(todayCal.get(Calendar.DATE));
//
//        } else {
//            endCal.add(Calendar.DATE, 1);
//            resultEndDatePlusOne =
//                    endCal.get(Calendar.YEAR) + "-" +
//                            DECIMAL_FORMAT.format((endCal.get(Calendar.MONTH) + 1)) + "-" +
//                            DECIMAL_FORMAT.format(endCal.get(Calendar.DATE));
//        }
//        dates[TO] = "" + resultEndDatePlusOne + " 00:00:00";
//
//        Log.i("DateRange", "From : " + dates[FROM]);
//        Log.i("DateRange", "To : " + dates[TO]);
//
//        return dates;
//    }

    public static String[] getDateRange(int year, int month, int before, int startDay) {

        if (startDay == 0) {
            startDay = 1;
        }
        String[] dates = new String[2];

        Calendar calendar = Calendar.getInstance();

        int day = calendar.get(Calendar.DATE);

        //day 1, startDay 2
//        boolean shouldMinusOneMonth = day < startDay;


        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DATE, startDay);

        calendar.add(Calendar.MONTH,  -1 * before);
//        if(shouldMinusOneMonth) {
//            calendar.add(Calendar.MONTH, -1);
//        }
        // 8월 12일
        dates[FROM] = calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.DATE)) + " 00:00:00";

        calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DATE, startDay);

//        if(!shouldMinusOneMonth) {
            calendar.add(Calendar.MONTH, 1);
//        }

        dates[TO] = calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.DATE)) + " 00:00:00";

        return dates;

    }

    public static String[] getDateRangeAnalysis(int year, int month, int before, int startDay) {

        if (startDay == 0) {
            startDay = 1;
        }
        String[] dates = new String[2];

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DATE, startDay);

        calendar.add(Calendar.MONTH,  -1 * before);

        dates[FROM] = calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.DATE)) + " 00:00:00";

        calendar.add(Calendar.MONTH, 1);
        dates[TO] = calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.DATE)) + " 00:00:00";

        return dates;

    }

    public static int getCategoryIcon(int categoryCode) {

        switch (categoryCode) {
            case UNCATE:

                return R.drawable.ic_withdraw_etc;

            case FOOD:

                return R.drawable.ic_withdraw_food;

            case CAFE:

                return R.drawable.ic_withdraw_cafe;

            case ALCOHOL:

                return R.drawable.ic_withdraw_alcohol;

            case MART:

                return R.drawable.ic_withdraw_mart;

            case ONLINE:

                return R.drawable.ic_withdraw_online;

            case SHOPPING:

                return R.drawable.ic_withdraw_shopping;

            case FINANCE:

                return R.drawable.ic_withdraw_finance;

            case HEALTHCARE:

                return R.drawable.ic_withdraw_health_care;

            case BEAUTY:

                return R.drawable.ic_withdraw_beauty;

            case LIVINGS:

                return R.drawable.ic_withdraw_livings;

            case EDUCATION:

                return R.drawable.ic_withdraw_education;

            case CULTURE:

                return R.drawable.ic_withdraw_culture;

            case TRANSPORT:

                return R.drawable.ic_withdraw_transport;

            case LEPORTS:

                return R.drawable.ic_withdraw_leports;

            case TRAVEL:

                return R.drawable.ic_withdraw_travel;

            case FAMILY_EVENT:

                return R.drawable.ic_withdraw_family_event;

            case WITHDRAW_CODE:

                return R.drawable.ic_withdraw;

            case WITHDRAW_MOVING_ASSET:

                return R.drawable.ic_withdraw_moving_asset;

            case DEPOSIT_ETC:

                return R.drawable.visual_ic_deposit_etc;

            case INCOME_MAIN:

                return R.drawable.visual_ic_deposit_income_main;

            case INCOME_SUB:

                return R.drawable.ic_deposit_income_sub;

            case DEPOSIT_LOAN:

                return R.drawable.visual_ic_deposit_loan;

            case DEPOSIT_MOVING_ASSET:

                return R.drawable.ic_deposit_moving_asset;

            default:

                return 0;

        }
    }

    public static boolean isNotiEnabled(Context context) {
        return NotificationManagerCompat.getEnabledListenerPackages(context).contains(context.getPackageName());
    }

    public static ArrayList<String> getDailyDateRanges(int before) {

        ArrayList<String> resultItems = new ArrayList<>();

        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1 * before);
        String startStr = calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format((calendar.get(Calendar.MONTH) + 1)) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.DATE));
        resultItems.add(startStr);
        resultItems.add(startStr);

        return resultItems;

    }

    public static ArrayList<String> getWeeklyDateRanges(int before) {

        ArrayList<String> resultItems = new ArrayList<>();

        String startStr, endStr;
        int startDateNum, endDateNum;

        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        Calendar todayCal = Calendar.getInstance();

        int dayOfWeek = todayCal.get(Calendar.DAY_OF_WEEK);

        if (dayOfWeek == 1) {
            startDateNum = -7 * before - 6;
            endDateNum = -7 * before;
        } else {
            startDateNum = -7 * before - (dayOfWeek - 2);
            endDateNum = -7 * before + 8 - dayOfWeek;
        }

        startCal.add(Calendar.DATE, startDateNum);//주시작일

        startStr = startCal.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format((startCal.get(Calendar.MONTH) + 1)) + "-" + DECIMAL_FORMAT.format(startCal.get(Calendar.DATE));

        resultItems.add(startStr);

        endCal.add(Calendar.DATE, endDateNum);//주 마지막

        endStr = endCal.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format((endCal.get(Calendar.MONTH) + 1)) + "-" + DECIMAL_FORMAT.format(endCal.get(Calendar.DATE));
        resultItems.add(endStr);

        return resultItems;
    }

    public static boolean compareDate(Calendar beforeDate, Calendar afterDate) {

        try {
            return beforeDate.before(afterDate) || beforeDate.equals(afterDate);
        } catch (Exception e) {
            return false;
        }

    }

    public static boolean compareDate(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(getYMD(beforeDate) +" 00:00:00");
            Date after = fullDF.parse(getYMD(afterDate) +" 00:00:00");

            return before.before(after) || before.equals(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean compareDateBefore(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(getYMD(beforeDate) +" 00:00:00");
            Date after = fullDF.parse(getYMD(afterDate) +" 00:00:00");

            return before.before(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean compareDatetime(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(beforeDate);
            Date after = fullDF.parse(afterDate);

            return before.before(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean equalsDatetime(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(beforeDate);
            Date after = fullDF.parse(afterDate);

            return before.equals(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean equalsDate(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(getYMD(afterDate) + " 00:00:00");

            return before.equals(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean ltDate(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(getYMD(afterDate) + " 00:00:00");

            return before.before(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean gtDate(String beforeDate, String afterDate) {

        try {
            Date before = fullDF.parse(getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(getYMD(afterDate) + " 00:00:00");

            return before.after(after);
        } catch (Exception e) {
            return false;
        }
    }

    public static String getYMD(Calendar date) {
        int year = date.get(Calendar.YEAR);
        int month = date.get(Calendar.MONTH) + 1;
        int day = date.get(Calendar.DATE);
        return "" + year + "-" + DECIMAL_FORMAT.format(month) + "-" + DECIMAL_FORMAT.format(day);
    }

    public static String getHMS(Calendar date) {
        int hour = date.get(Calendar.HOUR_OF_DAY);
        int minute = date.get(Calendar.MINUTE);
        int second = date.get(Calendar.SECOND);
        return "" + DECIMAL_FORMAT.format(hour) + ":" + DECIMAL_FORMAT.format(minute) + ":" + DECIMAL_FORMAT.format(second);
    }

    public static String getYM(String date) {
        return date.substring(0, 7);
    }

    public static String getYMD(String date) {
        return date.substring(0, 10);
    }

    public static String getYM(Calendar date) {
        int year = date.get(Calendar.YEAR);
        int month = date.get(Calendar.MONTH) + 1;
        return "" + year + "-" + DECIMAL_FORMAT.format(month);
    }

    public static long toTime(String dateStr) {
        try {
            Date date = fullDF.parse(dateStr);
            return date.getTime();
        } catch (ParseException e) {

        }
        return 0;
    }

    public static Calendar toCalendar(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = fullDF.parse(dateStr);
            calendar.setTime(date);
        } catch (ParseException e) {

        }
        return calendar;
    }

    public static Calendar toCalendarYMD(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = ymdDF.parse(dateStr);
            calendar.setTime(date);
        } catch (ParseException e) {

        }
        return calendar;
    }

    public static Calendar toCalendarHMS(String time) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = timeDf.parse(time);
            calendar.setTime(date);
        } catch (ParseException e) {

        }
        return calendar;
    }


    public static int getDiffDay(Calendar before, Calendar after) {

        before.set(Calendar.HOUR_OF_DAY, 0);
        before.set(Calendar.MINUTE, 0);
        before.set(Calendar.SECOND, 0);

        after.set(Calendar.HOUR_OF_DAY, 0);
        after.set(Calendar.MINUTE, 0);
        after.set(Calendar.SECOND, 0);


        long start, end;
        start = before.getTimeInMillis();
        end = after.getTimeInMillis();
        Long diff = (end - start) / (1000 * 60 * 60 * 24);

        return diff.intValue() + 1;
    }

    public static boolean isOddDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.DATE) % 2 != 0;
    }

    public static boolean isEvenDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.DATE) % 2 == 0;

    }

    public static int getDeviceHeight(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static double calculateCurrency(double money, String currency) {

        if ("USD".equals(currency)) {
            return (money * 1063.25);
        } else if ("THB".equals(currency)) {
            return (money * 33.29);
        } else if ("JPY".equals(currency)) {
            return  (money * 9.60);
        } else if ("CNY".equals(currency)) {
            return  (money * 165.08);
        } else if ("RUB".equals(currency)) {
            return  (money * 18.88);
        } else if ("TWD".equals(currency)) {
            return  (money * 36);
        } else if ("AUD".equals(currency)) {
            return  (money *  845.22);
        } else if ("NZD".equals(currency)) {
            return  (money * 773.95);
        } else if ("SGD ".equals(currency)) {
            return  (money * 804.24);
        } else if ("HKD".equals(currency)) {
            return  (money * 135.91);
        } else if ("PHP".equals(currency)) {
            return  (money * 21.09);
        } else if ("IDR".equals(currency)) {
            return  (money * 0.079);
        } else if ("INR ".equals(currency)) {
            return  (money * 16.759);
        } else if ("MYR".equals(currency)) {
            return ( money * 269.73);
        } else if ("EUR".equals(currency)) {
            return  (money * 1298.80);
        } else if("GBP".equals(currency)) {
            return (money*1462.11);
        } else if("VND".equals(currency)) {
            return (money* 0.047);
        } else if ("CAD".equals(currency)) {
            return (money*854.42);
        } else if("DKK".equals(currency)) {
            return (money*174.36);
        } else {
            return money;
        }

    }

    public static void changeColor(LinearLayout container, int color) {
        Drawable background = container.getBackground();
         if (background instanceof GradientDrawable) {
            ((GradientDrawable)background).setStroke(3, color);
        }
    }

    public static int dpToPx(int dp) {
        return (int) (dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static Calendar convertStringToCalendarFULL(String date){
        Calendar resultCal = Calendar.getInstance();
        Date d;
        if(date == null || TextUtils.isEmpty(date)) {
            return resultCal;
        }
        try {

            d = fullDF.parse(date);
            resultCal.setTime(d);
        } catch (Exception e) {

        }

        return resultCal;
    }


    public static void fixInputMethod(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager inputMethodManager = null;
        try {
            inputMethodManager = (InputMethodManager) context.getApplicationContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (inputMethodManager == null) {
            return;
        }
        Field[] declaredFields = inputMethodManager.getClass().getDeclaredFields();
        for (Field declaredField : declaredFields) {
            try {
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                Object obj = declaredField.get(inputMethodManager);
                if (obj == null || !(obj instanceof View)) {
                    continue;
                }
                declaredField.set(inputMethodManager, null);
            } catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}
