/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.util.SparseArray;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.JoinedContent;
import java.util.ArrayList;

public class AnalysisRepository {
    private static AnalysisRepository mInstance;
    private final ContentsDao contentsDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalysisRepository getInstance(ContentsDao contentsDao) {
        Class<AnalysisRepository> clazz = AnalysisRepository.class;
        synchronized (AnalysisRepository.class) {
            if (mInstance == null) {
                mInstance = new AnalysisRepository(contentsDao);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AnalysisRepository(ContentsDao contentsDao) {
        this.contentsDao = contentsDao;
    }

    public ArrayList<JoinedContent> loadContents() {
        ArrayList<Content> contents = this.contentsDao.loadContents();
        SparseArray<ArrayList<Condition>> conditionMaps = this.contentsDao.loadConditions();
        ArrayList<JoinedContent> results = new ArrayList<JoinedContent>();
        for (Content content : contents) {
            results.add(new JoinedContent(content, (ArrayList)conditionMaps.get(content.getId())));
        }
        return results;
    }
}

