/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Advertisement;
import java.util.ArrayList;

public class AdvertisementDao {
    private final Db db;

    public AdvertisementDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSatisfied(String query) {
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                boolean bl = c.getInt(0) == 1;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Advertisement> loadAds() {
        String query = QueryGenerator.advertisement();
        ArrayList<Advertisement> results = new ArrayList<Advertisement>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.AdvertisementTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void merge(Advertisement advertisement) {
        try {
            ContentValues values = new ContentValues();
            values.put("adId", Integer.valueOf(advertisement.getId()));
            values.put("adTitle", advertisement.getTitle());
            values.put("adLabel", advertisement.getLabel());
            values.put("adContent", advertisement.getContent());
            values.put("adLinkTo", advertisement.getLinkTo());
            values.put("adLinkToType", advertisement.getLinkToType());
            values.put("adLinkToStr", advertisement.getLinkToStr());
            values.put("adImage", advertisement.getImage());
            values.put("adIconImage", advertisement.getImage());
            values.put("adPriority", Integer.valueOf(advertisement.getPriority()));
            values.put("adQuery", advertisement.getQuery());
            values.put("adBgColor", advertisement.getColors().getBgColor());
            values.put("adTitleColor", advertisement.getColors().getTitleColor());
            values.put("adContentColor", advertisement.getColors().getContentColor());
            values.put("adLabelColor", advertisement.getColors().getLabelColor());
            values.put("adLinkColor", advertisement.getColors().getLinkToColor());
            this.db.insertOnReplace(" ADVERTISEMENTS ", values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

