package com.tenqube.visual_third.parser.loader;


import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import androidx.annotation.Nullable;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.SyncListener;
import com.tenqube.visual_third.SyncService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.SyncData;
import com.tenqube.visual_third.model.parser.SyncTransaction;
import com.tenqube.visual_third.parser.SyncHolder;
import com.tenqube.visual_third.parser.executor.BulkExecutor;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.manager.PrefManager.RESTORE_STATUS;
import static com.tenqube.visual_third.parser.executor.BulkExecutor.FINISH;
import static com.tenqube.visual_third.parser.executor.BulkExecutor.PROGRESS;
import static com.tenqube.visual_third.parser.executor.BulkExecutor.SYNC_ERROR;
import static com.tenqube.visual_third.util.Utils.getConvertedDate;
import static com.tenqube.visual_third.util.Utils.isEmpty;

public class BulkLoader extends BaseLoader implements BulkSmsAdapter {

    private static final String TAG = BulkLoader.class.getSimpleName();
    private static final int BULK_MONTH = -3;
    private Cursor mCursor;
    private final Handler mHandler;

    private long fromSmsDate;

    private boolean isCanceled;

    public void cancelParseBulk() {

        isCanceled = true;
        if(parserService != null) {
            parserService.cancelParseBulk();

        }
    }
    /**
     * @param context 컨텍스트
     * @param handler 진행상태 메세지 전송 handler
     */
    public BulkLoader(Context context,
                      Handler handler) {
        super(context);
        this.mHandler = handler;
    }

    public void doParsing(final boolean isInit) {

        if(isInit) {
            repository.initialize(new Callback<Boolean>() {
                @Override
                public void onDataLoaded(Boolean value) {
                    parsing(true);
                }
            });
        } else {
            parsing(false);
        }
    }

    private void parsing(final boolean isInit) {

            syncParsingRule(new Callback<Boolean>() {
                @Override
                public void onDataLoaded(Boolean value) {
                    // 마지막 날짜이후 파싱 진행
                    sync(new Callback<Boolean>() {
                        @Override
                        public void onDataLoaded(@Nullable Boolean success) {

                            prefManager.saveStringValue(RESTORE_STATUS, success == null ?
                                    com.tenqube.visual_third.Constants.NONE :
                                    success? com.tenqube.visual_third.Constants.SUCCESS
                                            :
                                            com.tenqube.visual_third.Constants.FAIL);

                            if(success != null && !success) {
                                if(isInit) {
                                    sendHandlerMsg(null, SYNC_ERROR, 0);
                                } else {
                                    sendHandlerMsg(null, BulkExecutor.ERROR, 0);
                                }
                            } else {
                                if(isInit) {
                                    mHandler.sendEmptyMessage(BulkExecutor.SHOW_PROGRESS_BAR);
                                    mHandler.sendEmptyMessage(BulkExecutor.CLOSE_SYNC_PROGRESS_BAR);
                                }

                                // cursor 초기화
                                initCursor();

                                // parseBulk
                                parserService.parseBulk(BulkLoader.this);

                            }
                        }
                    });

                }
            });

    }

    /**
     * 50% sync 로 진행
     */
    private void sync(final Callback<Boolean> callback) {
        final SyncService syncService = SyncHolder.getInstance().getSyncService();
        if(syncService != null) {

                syncService.getSyncData(new SyncListener() {
                    @Override
                    public void onSuccess(final SyncData syncData) {

                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    if(syncData != null && !syncData.getTransactions().isEmpty()) {

                                        fromSmsDate = getLastSmsDate(syncData.getTransactions());
                                        List<SyncTransaction> transactions = syncData.getTransactions();
                                        int total = transactions.size();
                                        Utils.LOGD("sync", "sync size: " + total);
                                        Utils.LOGD("sync", "getLastSmsDate: " + fromSmsDate);

                                        int i = 0;
                                        for(SyncTransaction tran : transactions) {

//                                Utils.LOGD("sync", "tran identifier: " + tran.identifier);
//                                Utils.LOGD("sync", "tran spentDate: " + tran.spentDate);

                                            sendProgress(i, total);
                                            repository.insertTransaction(tran);
                                            i++;
                                        }
                                        onResult(syncService, true);

                                        callback.onDataLoaded(true);

                                    } else { //restore 데이터가 없는 경우
                                        onResult(syncService, true);

                                        callback.onDataLoaded(null);
                                    }

                                } catch (Exception e) {
                                    onResult(syncService, false);
                                    callback.onDataLoaded(false);
                                }

                            }
                        }).start();

                    }

                    @Override
                    public void onError() {
                        onResult(syncService, false);
                        callback.onDataLoaded(false);
                    }

                });
            } else {
                callback.onDataLoaded(true);

            }

    }

    private void onResult(final SyncService syncService, final boolean isSuccess) {

        new Handler(mContext.getMainLooper()).post(new Runnable() {

            @Override
            public void run() {
                syncService.onResult(isSuccess);
            }
        });

    }

    private long getLastSmsDate(List<SyncTransaction> transactions) {
        long maxTime = 0;

        long today = new Date().getTime();

        for(SyncTransaction tran : transactions) {

            long time = Utils.toTime(tran.spentDate);
            if(time <= today) {
                if(time > maxTime) {
                    maxTime = time;
                }
            }

        }
        return maxTime;
    }

    private long getToSmsDate() {
        return prefManager.loadLongValue(PrefManager.FIRST_SMS_DATE, prefManager.loadLongValue(PrefManager.SIGN_UP_TIME, Calendar.getInstance().getTimeInMillis()));
    }

    private void initCursor() {

        try {
            Uri uri = Uri.parse("content://sms/inbox");
            mCursor = mContext.getContentResolver().query(uri, null, getWhere(), null, "date asc");
            if (mCursor != null) {
                mCursor.moveToFirst();
            }
        } catch (Exception e) {
            onError(1);
        }

    }

    private long getFromTime(long toTime) {
        if(fromSmsDate != 0) {
            return fromSmsDate;
        } else {
//            Calendar calendar = Calendar.getInstance();
//            calendar.setTimeInMillis(toTime);
//
//            LOGI(TAG, "BulkTime toDate: " + Utils.getStringDateAsYYYYMMddHHmmss(calendar), mIsDebug);
//
//            int month = calendar.get(Calendar.MONTH);
//            calendar.set(Calendar.MONTH, month);
//            calendar.set(Calendar.DATE, 1);
//
//            calendar.set(Calendar.HOUR_OF_DAY, 0);
//            calendar.set(Calendar.MINUTE, 0);
//            calendar.set(Calendar.SECOND, 0);
//            calendar.set(Calendar.MILLISECOND, 0);
//
//            calendar.add(Calendar.MONTH, BULK_MONTH);

            return 0;
        }
    }

    private String getWhere() {
        long toTime = getToSmsDate();
        long fromTime = getFromTime(toTime);
         Utils.LOGD(TAG, "BulkTime fromDate: " + Utils.getConvertedDate(fromTime));
         Utils.LOGD(TAG, "BulkTime toDate: " + Utils.getConvertedDate(toTime));
        return  "date > " + fromTime + " and date < " + toTime;
    }

    @Override
    public int getSmsCount() {
        return mCursor == null ? 0 : mCursor.getCount();
    }

    @Override
    public SMS getSmsAt(int n) {
        return getSMS();
    }

    private SMS getSMS() {
        SMS sms = null;
        if (mCursor != null) {
            sms = new SMS(mCursor.getInt(mCursor.getColumnIndex("_id")),
                mCursor.getString(mCursor.getColumnIndex("body")),
                mCursor.getString(mCursor.getColumnIndex("address")),
                mCursor.getString(mCursor.getColumnIndex("address")),
                getConvertedDate(mCursor.getLong(mCursor.getColumnIndex("date"))),
                Constants.SMSType.SMS.ordinal());
            mCursor.moveToNext();
        }

        return sms;
    }

    /**
     * @param now 현재 내역 수
     * @param total 전체 내역 수
     */
    @Override
    public void onProgress(int now, int total) {
        //ui 변경
        sendProgress(now, total);

    }

    private boolean hasSync() {
        return fromSmsDate != 0;
    }

    private void sendProgress(int now, int total) {
        Bundle bundle = new Bundle();
        bundle.putInt("now", now);
        bundle.putInt("total", total);

        sendHandlerMsg(bundle,
                PROGRESS,
                0);
    }

    /**
     * 구버전의 경우 v1형태에 맞게 구성후 검색서버 반영되면 변경 처리
     * doGrouping
     * @param parsedTransactions 파싱된 지출내역 목록
     * @param callback 성공여부 콜백 메소드
     */
    @Override
    public void sendToServerTransactions(final ArrayList<Transaction> parsedTransactions, final OnNetworkResultListener callback) {

        try {

            if(!isCanceled) {
                // 31개가 오는경우가있음 parser 확인
                ArrayList<Transaction> subParsedTransactions = parsedTransactions.size() > 30 ? (ArrayList<Transaction>) parsedTransactions.subList(0, 30) : parsedTransactions;
                ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions = Mapper.toParserTransactions(subParsedTransactions);
                setCurrency(transactions);

                repository.mergeTransactions(transactions);

                ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
                if(!isEmpty(apiTransactions)) {
                    SearchCompanyResponse response = repository.searchCompany(new SearchCompanyRequest(apiTransactions));
                    if(response != null) {
                        repository.updateTransactions(response);
                    }
                }
                repository.syncTransactions(callback);
            }

        } catch (Exception e) {
            callback.onResult(true);
        }
    }

    @Override
    public void onCompleted() {

        Utils.LOGD("BulkHandler onCompleted", "");

        sendHandlerMsg(null, FINISH, 0);

        if(repository != null) {
            repository.saveBulk();
        }

        if(mCursor != null)
            mCursor.close();

    }

    @Override
    public void onError(final int resultCode) {
        Utils.LOGD("BulkHandler onError", "");

        //파싱룰 동기화가 필요한경우
        sendHandlerMsg(null, FINISH, 0);

        if(mCursor != null)
            mCursor.close();


    }

    private void sendHandlerMsg(Bundle data, int what, int arg1) {

        if(mHandler != null) {

            Message hMsg = mHandler.obtainMessage();
            if(data != null) hMsg.setData(data);
            hMsg.what = what;
            hMsg.arg1 = arg1;
            mHandler.sendMessage(hMsg);
        }
    }


}
