package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.isDate;
import static com.tenqube.visual_third.util.Validator.isStr;
import static com.tenqube.visual_third.util.Validator.isStrWithNull;
import static com.tenqube.visual_third.util.Validator.len;
import static com.tenqube.visual_third.util.Validator.lt;
import static com.tenqube.visual_third.util.Validator.notNull;
import static com.tenqube.visual_third.util.Validator.notZero;

public class UpdateTransactionRequest extends Request implements Serializable {

    private int id;
    private int lCode;
    private int mCode;
    private int cateConfigId;
    private String keyword;
    private double amount;
    private int cardId;
    private int installmentCnt;
    private String date;
    private String memo;
    private boolean isExpense;
    private boolean isAll;
    private String callbackJS;

    public int getTranId() {
        return id;
    }

    public int getlCode() {
        return lCode;
    }

    public int getmCode() {
        return mCode;
    }

    public int getCateConfigId() {
        return cateConfigId;
    }

    public String getKeyword() {
        return keyword;
    }

    public double getAmount() {
        return amount;
    }

    public int getCardId() {
        return cardId;
    }

    public int getInstallmentCnt() {
        return installmentCnt == 0 ? 1 : installmentCnt;
    }

    public String getDate() {
        return date;
    }

    public String getMemo() {
        return memo;
    }

    public boolean isExpense() {
        return isExpense;
    }

    public boolean isAll() {
        return isAll;
    }

    public String getCallbackJS() {
        return callbackJS;
    }


    @Override
    public void checkParams() throws ParameterException {
        notZero(id);
        notZero(cardId);
        notZero(cateConfigId);


        len("" + lCode, 2);
        len("" + mCode, 2);
        isStr(keyword, 50);
        gt(installmentCnt, 0);
        lt(installmentCnt, 25);
        isDate(date);
        isStrWithNull(memo, 300);
        notNull(callbackJS);

    }
}
