package com.tenqube.visual_third.web;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Utils;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SystemImpl extends Base implements VisualInterface.System  {

    private String callbackNoti;

    public SystemImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error) {
        super(context, contractor, webView, error);
    }

    public void onNotiCallback(final String json) {
        callbackWithStr(callbackNoti, json);
    }

    @JavascriptInterface
    public void startNotiListener(final String callback) {

        String funcName = "startNotiListener";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;
            contractor.showNotiCatch();

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void goNotiSettings(final String callback) {

        String funcName = "goNotiSettings";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;

            try {
                contractor.goNotiSettings();
            } catch (ActivityNotFoundException e){
                e.printStackTrace();
                onError(funcName, e.toString());
            }

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public boolean isNotiEnabled() {

        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(context);
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return false;
    }

    /**
     * 네트워크 연결 여부
     */
    @JavascriptInterface
    public boolean isNetworkConnected() {

        String funcName = "isNetworkConnected";

        try {
            ConnectivityManager cm =
                    (ConnectivityManager)context.getSystemService(Context.CONNECTIVITY_SERVICE);

            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null &&
                    activeNetwork.isConnectedOrConnecting();

            return isConnected;
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return true;

    }

}
