package com.tenqube.visual_third.util;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;

import static com.google.gson.internal.$Gson$Preconditions.checkNotNull;

public class ActivityUtils {

    public static void addFragmentToActivity (@NonNull FragmentManager fragmentManager,
                                              @NonNull Fragment fragment, int frameId, String tag, boolean isBackStack) {

        try {
            checkNotNull(fragmentManager);
            checkNotNull(fragment);
            if(!fragmentManager.isDestroyed()) {
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.replace(frameId, fragment, tag);
                if(isBackStack) transaction.addToBackStack(null);
                transaction.commit();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

}
