package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.notNull;

public class TimeRequest extends Request implements Serializable {

    private String time; // 22:22:22

    private String callbackJS;


    @Override
    public void checkParams() throws ParameterException {
        Validator.isTime(time);
        notNull(callbackJS);
    }

    public String getTime() {
        return time;
    }

    public String getCallbackJS() {
        return callbackJS;
    }
}
