package com.tenqube.visual_third.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;

import java.util.Calendar;

import static com.tenqube.visual_third.provider.VisualContract.AUTHORITY;

public class VisualProvider extends ContentProvider {

    private static final UriMatcher sUriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
    private VisualRepository repository;

    public boolean onCreate() {
        repository = VisualRepository.getInstance(getContext());
        return true;
    }

    static {

        sUriMatcher.addURI(AUTHORITY, "month", Constants.ProviderType.MONTH);
        sUriMatcher.addURI(AUTHORITY, "week", Constants.ProviderType.WEEK);
        sUriMatcher.addURI(AUTHORITY, "card", Constants.ProviderType.CARD);
        sUriMatcher.addURI(AUTHORITY, "category", Constants.ProviderType.CATEGORY);
        sUriMatcher.addURI(AUTHORITY, "keyword", Constants.ProviderType.KEYWORD);

    }

    @Override
    public Cursor query(
            Uri uri,
            String[] projection,
            String selection,
            String[] selectionArgs,
            String sortOrder) {

        try {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(Calendar.YEAR);
            int month = calendar.get(Calendar.MONTH) + 1;

            String[] dates;
            int groupType = sUriMatcher.match(uri);

            switch (groupType) {
                case Constants.ProviderType.MONTH:
                case Constants.ProviderType.CARD:
                case Constants.ProviderType.CATEGORY:
                case Constants.ProviderType.KEYWORD:
                    dates = Utils.getDateRange(year, month, 0);
                    break;
                case Constants.ProviderType.WEEK:
                    dates = Utils.getWeeklyDateRanges(0).toArray(new String[0]);
                    break;
                default:
                    return null;
            }


            Cursor cursor = repository.getSum(dates[0], dates[1], groupType);


            return cursor;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;

    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
