/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;

public class ProgressDialogFragment
extends DialogFragment {
    public static final String TAG = ProgressDialogFragment.class.getSimpleName();
    private Context context;
    private ProgressBar progressBar;
    private TextView percentTextView;

    public static ProgressDialogFragment newInstance(Context context) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        return new ProgressDialogFragment();
    }

    public void setProgressValue(int now, int total, int progress) {
        this.progressBar.setProgress(progress);
        this.percentTextView.setText((CharSequence)(progress + "%"));
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            if (this.context == null) {
                this.context = this.getActivity();
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_progress, null);
            this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
            this.percentTextView = (TextView)view.findViewById(R.id.percent);
            builder.setView(view);
            AlertDialog dialog = builder.create();
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(-1, -2);
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }
}

