/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AlertDialog;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

public class SystemImpl
extends Base
implements VisualInterface.System {
    private String callbackNoti;
    AlertDialog notiDialog;

    public SystemImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error) {
        super(context, contractor, webView, error);
    }

    @Override
    public void onNotiCallback(String json) {
        this.callbackWithStr(this.callbackNoti, json);
    }

    @Override
    @JavascriptInterface
    public void startNotiListener(final String callback) {
        String funcName = "startNotiListener";
        try {
            Validator.isStr(callback, 100);
            this.callbackNoti = callback;
            AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
            builder.setTitle((CharSequence)"\uc9c0\uae08\ubd80\ud130 \uc54c\ub9bc\uc744 \uac00\uacc4\ubd80\uc5d0 \uae30\ub85d\ud569\ub2c8\ub2e4.");
            builder.setPositiveButton((CharSequence)"\ub2e4\uc74c", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SystemImpl.this.goNotiSettings(callback);
                    if (SystemImpl.this.notiDialog != null) {
                        SystemImpl.this.notiDialog.dismiss();
                    }
                }
            });
            this.notiDialog = builder.create();
            this.notiDialog.show();
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void goNotiSettings(String callback) {
        String funcName = "goNotiSettings";
        try {
            Validator.isStr(callback, 100);
            this.callbackNoti = callback;
            try {
                Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                this.context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                this.onError(funcName, e.toString());
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNotiEnabled() {
        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
            return false;
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNetworkConnected() {
        String funcName = "isNetworkConnected";
        try {
            ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(funcName, e.toString());
            return true;
        }
    }
}

