package com.tenqube.visual_third.util;

import android.webkit.WebView;

import com.tenqube.visual_third.BuildConfig;
import com.tenqube.visual_third.manager.PrefManager;

public class WebViewHelper {

    public static void settings(WebView webView) {
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.getSettings().setDatabaseEnabled(true);
        webView.getSettings().setLoadWithOverviewMode(true);
        webView.getSettings().setUseWideViewPort(true);
    }

    public static String getBaseUrl(PrefManager prefManager) {
        String url = prefManager.loadStringValue(PrefManager.WEB_URL, "") + "/#v=" + BuildConfig.RICHNCO_WEB_VERSION +
                "&userName=" + prefManager.loadStringValue(PrefManager.USER_NAME, "");
        return url;
    }
}
