package com.tenqube.visual_third;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.VisualActivityFragment;

import static com.tenqube.visual_third.ui.VisualActivityFragment.ARG_PATH;

public class VisualActivity extends AppCompatActivity implements VisualActivityFragment.OnFragBackListener{

    VisualServiceImpl visualService;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_visual);

        try {
            // visual service 생성
            visualService = new VisualServiceImpl(this, "ae1PfOEo05yWVZByl1hv1XQ5twQUAyo8UeGhF1zf", Constants.DEV);
            visualService.setDebugMode(true); // 개발자 모드 설정 (로그 확인이 가능합니다.)
            visualService.setDeepLink("sample://main");
            findViewById(R.id.button).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onWeb(v);
                }
            });

            visualService.startVisual(VisualActivity.this, R.id.container, false, "1234", getVisualPath(), "굿리치");
        } catch (ParameterException  | SecurityException e) {
            e.printStackTrace();
        }

    }

    private String getVisualPath() {
        Intent intent = getIntent();

        if (Intent.ACTION_VIEW.equals(intent.getAction())) {
            String visualPath = intent.getStringExtra(ARG_PATH);
            return visualPath;
        }

        return "";
    }

    public void onWeb(View view) {

        try {
            if (ContextCompat.checkSelfPermission(VisualActivity.this,
                    Manifest.permission.READ_SMS)
                    != PackageManager.PERMISSION_GRANTED) {

                // Should we show an explanation?
                if (ActivityCompat.shouldShowRequestPermissionRationale(VisualActivity.this,
                        Manifest.permission.READ_SMS)) {



                } else {

                    ActivityCompat.requestPermissions(VisualActivity.this,
                            new String[]{Manifest.permission.READ_SMS},
                            0);

                }
            } else {
                try {
                    visualService.startVisual(VisualActivity.this, R.id.container, false,"1234",  getVisualPath(), "굿리치");
                } catch (ParameterException e) { // 파라미터가 올바르지 않은경우 발생
                    e.printStackTrace();
                }
            }

        } catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case 0: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    try {
                        visualService.startVisual(VisualActivity.this, R.id.container, false, "1234", getVisualPath(), "굿리치");
                    } catch (ParameterException e) { // 파라미터가 올바르지 않은경우 발생
                        e.printStackTrace();
                    }

                    // permission was granted, yay! Do the
                    // contacts-related task you need to do.

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.
                }
                return;
            }

        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        VisualActivityFragment fragment = (VisualActivityFragment) getSupportFragmentManager().findFragmentById(R.id.container);
        if(fragment != null && fragment.isAdded()) {
            fragment.onBackPressed();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        VisualActivityFragment fragment = (VisualActivityFragment) getSupportFragmentManager().findFragmentById(R.id.container);
        if(fragment != null && fragment.isAdded()) {
            fragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onFragBackPressed() {
        super.onBackPressed();
    }
}
