/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.FusedLocationManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.util.LogUtil;

public class OneLoader
extends BaseLoader {
    public static final String ACTION_TRANSACTION_RECEIVED = "tenqube.intent.action.ACTION_TRANSACTION_RECEIVED";
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private final FusedLocationManager fusedLocationManager;
    private int mServerCnt = 0;

    private OneLoader(Context context) {
        super(context);
        this.fusedLocationManager = FusedLocationManager.getInstance(context);
    }

    public synchronized void doParsing(final SMS sms) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.LOGI((String)TAG, (String)("doParsing" + sms.toString()), (boolean)ParserService.mIsDebug);
                ParserResult parserResult = OneLoader.this.parserService.parse(sms);
                if (parserResult.resultCode != 1 && "com.samsung.android.spay".equals(sms.sender)) {
                    sms.fullSms = sms.title;
                    parserResult = OneLoader.this.parserService.parse(sms);
                }
                LogUtil.LOGI((String)TAG, (String)("parserResult" + parserResult.resultCode + ResultCode.stringValueOf((Integer)parserResult.resultCode)), (boolean)ParserService.mIsDebug);
                switch (parserResult.resultCode) {
                    case -4: {
                        OneLoader.this.syncParsingRule();
                        break;
                    }
                    case -6: {
                        if (!Utils.shouldParsing(sms.fullSms)) break;
                        OneLoader.this.syncParsingRuleAndNoSender();
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 1: {
                        OneLoader.this.fusedLocationManager.buildGoogleApiClient();
                        OneLoader.this.fusedLocationManager.onStart();
                        OneLoader.this.parsedSMS(parserResult.transactions);
                    }
                }
                OneLoader.this.fusedLocationManager.onStop();
            }
        }).start();
    }

    private void syncParsingRuleAndNoSender() {
        ++this.mServerCnt;
        if (this.mServerCnt == 10) {
            this.mServerCnt = 0;
            this.syncParsingRule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneLoader getInstance(Context context) {
        Class<OneLoader> clazz = OneLoader.class;
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private void parsedSMS(ArrayList<tenqube.parser.model.Transaction> parsedTransactions) {
        try {
            ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions = Mapper.toParserTransactions(parsedTransactions);
            com.tenqube.visual_third.model.parser.Transaction currentTran = this.getCurrentTransaction(transactions);
            if (currentTran == null) {
                return;
            }
            this.addLocationInfo(currentTran);
            this.setCurrency(transactions);
            this.repository.mergeTransactions(transactions);
            Transaction applyAllTran = this.repository.loadApplyAllTran(currentTran.getParsedTransaction().keyword);
            SearchCompanyResponse searchCompanyResponse = null;
            if (applyAllTran != null) {
                ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<SearchCompanyResponse.TranCompany>();
                SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(applyAllTran.getCompanyId(), applyAllTran.getFranchise(), "");
                SearchCompanyResponse.Category category = new SearchCompanyResponse.Category(applyAllTran.getCategoryCode() + "");
                SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(applyAllTran.getKeyword(), applyAllTran.getSearchKeyword());
                SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + applyAllTran.getIdentifier(), applyAllTran.getClassCode(), company, category, keyword);
                results.add(tranCompany);
                searchCompanyResponse = new SearchCompanyResponse(results);
            } else {
                ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
                if (!Utils.isEmpty(apiTransactions)) {
                    searchCompanyResponse = this.api.searchCompany(new SearchCompanyRequest(apiTransactions));
                }
            }
            if (searchCompanyResponse != null) {
                this.repository.updateTransactions(searchCompanyResponse);
                if (currentTran.getParsedTransaction().isDuplicate == 0) {
                    SearchCompanyResponse.TranCompany searchedCompany = this.findSearchedCompany(searchCompanyResponse, currentTran.getParsedTransaction());
                    this.startTranPopup(currentTran, searchedCompany);
                }
            }
            this.api.syncTransactions(null);
            LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(new Intent(ACTION_TRANSACTION_RECEIVED));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private com.tenqube.visual_third.model.parser.Transaction getCurrentTransaction(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        for (com.tenqube.visual_third.model.parser.Transaction transaction : transactions) {
            if (!transaction.getParsedTransaction().isCurrentTran) continue;
            return transaction;
        }
        return null;
    }

    private void addLocationInfo(com.tenqube.visual_third.model.parser.Transaction currentTran) {
        Location location = this.fusedLocationManager.getLocation();
        if (location != null) {
            currentTran.getParsedTransaction().spentLatitude = location.getLatitude();
            currentTran.getParsedTransaction().spentLongitude = location.getLongitude();
        } else {
            currentTran.getParsedTransaction().spentLatitude = -1.0;
            currentTran.getParsedTransaction().spentLongitude = -1.0;
        }
    }

    private SearchCompanyResponse.TranCompany findSearchedCompany(SearchCompanyResponse searchCompanyResponse, tenqube.parser.model.Transaction currentTran) {
        SearchCompanyResponse.TranCompany searchedCompany = null;
        for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
            if (!company.getIdentifier().equals(currentTran.identifier)) continue;
            searchedCompany = company;
            break;
        }
        return searchedCompany;
    }

    private void startTranPopup(final com.tenqube.visual_third.model.parser.Transaction currentTran, final SearchCompanyResponse.TranCompany company) {
        new Handler(this.mContext.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran, company);
                    TransactionPopupActivity.startActivity(OneLoader.this.mContext, transactionPopupInfo);
                }
                catch (ParameterException e) {
                    e.printStackTrace();
                }
                catch (AuthException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

