package com.tenqube.visual_third.web;

import android.webkit.JavascriptInterface;

public interface VisualInterface {

    interface Repo {

        @JavascriptInterface
        void deleteTransactions(final String params);

        @JavascriptInterface
        void getAds(final String params);

        @JavascriptInterface
        void getCategories(final String callback);

        @JavascriptInterface
        void getCards(final String callback);

        @JavascriptInterface
        void getTransactions(final String callback);

        @JavascriptInterface
        void getTransactionsByIds(final String callback);

        @JavascriptInterface
        void getLv0Contents(final String callback);

        @JavascriptInterface
        void updateTransaction(final String params);

        @JavascriptInterface
        void insertTransaction(final String params);

        @JavascriptInterface
        boolean shouldShowTranPopup();

        @JavascriptInterface
        void setTranPopup(boolean shouldShow);

    }

    interface UI {

        @JavascriptInterface
        void openConfirmBox(String params);

        @JavascriptInterface
        void openSelectBox(String params);

        @JavascriptInterface
        void openNewView(String params);

        @JavascriptInterface
        void finish(String path);

        @JavascriptInterface
        void showSnackBar(String msg);

        @JavascriptInterface
        void showToast(String msg);

        @JavascriptInterface
        void onPageLoaded(String params);

        @JavascriptInterface
        void onScrollChanged(int pos);

        @JavascriptInterface
        void onFinish();

        @JavascriptInterface
        void showDatePicker(String callback);

        @JavascriptInterface
        void showTimePicker(String callback);

        @JavascriptInterface
        void reload();

        @JavascriptInterface
        void retry();

        @JavascriptInterface
        void onCalendar(String date, String callback);

        @JavascriptInterface
        void setRefreshEnabled(boolean enabled);
    }

    interface System {

        @JavascriptInterface
        void startNotiListener(final String callback);

        @JavascriptInterface
        void goNotiSettings(final String callback);

        @JavascriptInterface
        boolean isNotiEnabled();

        @JavascriptInterface
        boolean isNetworkConnected();

        void onNotiCallback(String params);
    }

    interface Error {
        @JavascriptInterface
        void onError(String funcName, String msg);
    }

    interface Log {
        @JavascriptInterface
        void onKeyMetric(String parmas);
    }

}
