/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualWebActivity
extends AppCompatActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
ViewContractor {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_PATH = "ARG_PATH";
    public static final int POPUP_CODE = 1000;
    private PrefManager prefManager;
    private VisualApi api;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String path;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private SwipeRefreshLayout swipeRefreshLayout;

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);
    }

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        this.getWindow().addFlags(128);
        this.getWindow().setFlags(4, 4);
        super.onCreate(savedInstanceState);
        try {
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("VisualWebActivity"));
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.webview.setBackgroundColor(0);
            this.errorInterface = new ErrorImpl((Context)this, this, this.webview);
            this.logInterface = new LogImpl((Context)this, this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl((Context)this, this, this.webview, this.errorInterface, VisualRepository.getInstance((Context)this), this.api, new AnalysisServiceImpl((Context)this));
            this.uiInterface = new UiImpl((Context)this, this, this.webview, this.errorInterface, new BottomDialog((Activity)this));
            this.systemInterface = new SystemImpl((Context)this, this, this.webview, this.errorInterface);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.getSettings().setJavaScriptEnabled(true);
            this.webview.getSettings().setDomStorageEnabled(true);
            this.webview.getSettings().setDatabaseEnabled(true);
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    VisualWebActivity.this.loadErrorUrl();
                }
            });
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            this.loadUrl();
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private String getBaseUrl() {
        String url = this.prefManager.loadStringValue("TENQUBE_WEB_URL", "") + "/#v=" + "1.0.0";
        return url;
    }

    private void loadUrl() {
        if (this.webview != null) {
            this.isPageLoaded = false;
            if (TextUtils.isEmpty((CharSequence)this.path)) {
                this.path = "";
            }
            String url = this.getBaseUrl() + this.path;
            this.webview.loadUrl(url);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.webview != null) {
            this.webview.loadUrl("file:///android_asset/index.html");
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
        newFragment.show(this.getSupportFragmentManager(), "datePicker");
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
        newFragment.show(this.getSupportFragmentManager(), "timePicker");
    }

    @Override
    public void onFinish(String path) {
        Intent intent = this.getIntent();
        this.setResult(TextUtils.isEmpty((CharSequence)path) || "false".equals(path) ? 0 : -1, intent);
        this.finish();
    }

    @Override
    public void startPopup(String path) {
        Intent intent = new Intent(this.getApplicationContext(), VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        this.startActivityForResult(intent, 1000);
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.systemInterface == null) break;
                    this.systemInterface.onNotiCallback(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1000: {
                this.setResult(resultCode);
                this.finish();
                this.overridePendingTransition(0, 0);
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }
}

