package com.tenqube.visual_third.api;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class LogInterceptor implements Interceptor {

    private static final String TAG = LogInterceptor.class.getSimpleName();
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        LOGI(TAG, "***************************     REQUEST   ******************************", mIsDebug);

        LOGI(TAG, "request method : " + request.method(), mIsDebug);
        LOGI(TAG, "request url : " + request.url(), mIsDebug);
        LOGI(TAG, "request connection : " + chain.connection(), mIsDebug);

        Response response = chain.proceed(request);

        LOGI(TAG, "****************************      END    ********************************", mIsDebug);
        LOGI(TAG, "***************************     RESPONSE   ******************************", mIsDebug);

        LOGI(TAG, "response url : " + response.request().url(), mIsDebug);
        LOGI(TAG, "response header : " + response.headers(), mIsDebug);
        LOGI(TAG, "response code : " + response.code(), mIsDebug);
        if(response.body() != null)
            LOGI(TAG, "response body : " + response.body().string(), mIsDebug);


        LOGI(TAG, "****************************      END    ********************************", mIsDebug);


        return response;
    }
}
