/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.Calendar;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualActivityFragment
extends Fragment
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
ViewContractor {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_UID = "UID";
    private PrefManager prefManager;
    private VisualApi api;
    private String mFailingUrl;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private boolean isPageLoaded;
    private String uid;

    public static VisualActivityFragment newInstance(String uid) {
        VisualActivityFragment fragment = new VisualActivityFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_UID, uid);
        fragment.setArguments(bundle);
        return new VisualActivityFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.uid = this.getArguments().getString(ARG_UID, "");
        }
        this.api = VisualApi.getInstance((Context)this.getActivity());
        this.prefManager = PrefManager.getInstance((Context)this.getActivity());
        AnswerManager.initFabric((Context)this.getActivity());
        AnswerManager.onKeyMetric(new LogRequest("VisualActivityFragment"));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_visual_web, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualActivityFragment.this.swipeRefreshLayout.setRefreshing(false);
                    VisualActivityFragment.this.webview.reload();
                }
            });
            this.webview = (WebView)view.findViewById(R.id.visual_web_view);
            this.errorInterface = new ErrorImpl((Context)this.getActivity(), this, this.webview);
            this.logInterface = new LogImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, VisualRepository.getInstance((Context)this.getActivity()), this.api, new AnalysisServiceImpl((Context)this.getActivity()));
            this.uiInterface = new UiImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, new BottomDialog((Activity)this.getActivity()));
            this.systemInterface = new SystemImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.getSettings().setJavaScriptEnabled(true);
            this.webview.getSettings().setDomStorageEnabled(true);
            this.webview.getSettings().setDatabaseEnabled(true);
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualActivityFragment.this.mFailingUrl = failingUrl;
                    VisualActivityFragment.this.loadErrorUrl();
                }
            });
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            LinearLayout bulkContainer = (LinearLayout)view.findViewById(R.id.start_bulk);
            this.loadUrl();
            bulkContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VisualActivityFragment.this.signUp(VisualActivityFragment.this.uid, new OnResultListener(){

                        @Override
                        public void onResult(final int signUpResult, String msg) {
                            VisualActivityFragment.this.getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (signUpResult != 1) {
                                        VisualActivityFragment.this.loadUrl();
                                        try {
                                            VisualWebActivity.startActivity((Context)VisualActivityFragment.this.getActivity(), "");
                                        }
                                        catch (AuthException e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        VisualActivityFragment.this.loadErrorUrl();
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.getActivity().finish();
        }
    }

    private void loadUrl() {
        String url = String.format("http://%1$s.richnco-view.tenqube.kr/%2$s/", this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev"), TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", "")) ? "intro" : "landing");
        this.webview.loadUrl(url);
    }

    private void signUp(@NonNull String uid, final @NonNull OnResultListener onResultListener) {
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        final SignUpRequest signUpRequest = new SignUpRequest(uid);
        if (!TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            onResultListener.onResult(2, "already joined");
            return;
        }
        AnswerManager.onKeyMetric(new LogRequest("signUp"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SignUpResponse response = VisualActivityFragment.this.api.signUp(signUpRequest);
                    if (response == null) {
                        onResultListener.onResult(1, "network error");
                    } else {
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", response.getResults().getSearch().getUrl());
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", response.getResults().getSearch().getApiKey());
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_UID", response.getResults().getAuthorization().getSdk());
                        VisualActivityFragment.this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
                        if (response.getResults().getWeb() != null) {
                            VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_WEB_URL", response.getResults().getWeb().getUrl());
                        }
                        onResultListener.onResult(0, "success");
                    }
                }
                catch (Exception e) {
                    onResultListener.onResult(1, e.toString());
                }
            }
        }).start();
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.webview != null) {
            this.webview.loadUrl("file:///android_asset/index.html");
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualActivityFragment.this.isPageLoaded = true;
            }
        });
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualActivityFragment.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
        newFragment.show(this.getActivity().getSupportFragmentManager(), "datePicker");
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
        newFragment.show(this.getActivity().getSupportFragmentManager(), "timePicker");
    }

    @Override
    public void onFinish(String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            Intent intent = this.getActivity().getIntent();
            intent.putExtra("path", path);
            this.getActivity().setResult(-1, intent);
        }
        this.getActivity().finish();
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.loadUrl(VisualActivityFragment.this.mFailingUrl);
                }
            });
        }
    }
}

