package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.isYMD;
import static com.tenqube.visual_third.util.Validator.notNull;

public class SmsReloadRequest extends Request implements Serializable {

    private String from; // 2018-10-10

    private String to; // 2018-10-10

    private String callbackJS;

    public SmsReloadRequest(String from, String to, String callbackJS) {
        this.from = from;
        this.to = to;
        this.callbackJS = callbackJS;
    }

    public String getCallbackJS() {
        return callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        isYMD(from);
        isYMD(to);
        notNull(callbackJS);
    }

}
