package com.tenqube.visual_third.model.api;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

import tenqube.parser.constants.Constants;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.in;
import static com.tenqube.visual_third.util.Validator.isDate;
import static com.tenqube.visual_third.util.Validator.isStr;
import static com.tenqube.visual_third.util.Validator.isStrWithNull;
import static com.tenqube.visual_third.util.Validator.len;
import static com.tenqube.visual_third.util.Validator.lt;
import static com.tenqube.visual_third.util.Validator.notZero;

public class TransactionRequest implements Serializable {

    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return transactions;
    }

    public TransactionRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction implements Serializable {
        private String uid;
        private String identifier;
        private String cardName ;
        private String cardNum;
        private int cardType;
        private int cardSubType;
        private double spentMoney;
        private double oriSpentMoney;
        private String spentDate;
        private String finishDate;
        private String oriKeyword;
        private String searchKeyword;
        private int installmentCount;
        private int dwType;
        private String currency;
        private double balance;
        private String sender;
        private String fullSms = "";
        private String smsDate;
        private int smsType;
        private int isOffset;
        private int isDuplicate;
        private String memo;
        private double spentLatitude;
        private double spentLongitude;
        private int categoryCode;
        private int companyId;
        private String classCode;
        private int regId;

        private int isCustom;
        private int isUserUpdate;
        private int isUpdateAll;
        private int isDeleted;


        @Override
        public String toString() {
            return "Transaction{" +
                    "identifier='" + identifier + '\'' +
                    ", cardName='" + cardName + '\'' +
                    ", cardNum='" + cardNum + '\'' +
                    ", cardType=" + cardType +
                    ", cardSubType=" + cardSubType +
                    ", spentMoney=" + spentMoney +
                    ", oriSpentMoney=" + oriSpentMoney +
                    ", spentDate='" + spentDate + '\'' +
                    ", finishDate='" + finishDate + '\'' +
                    ", oriKeyword='" + oriKeyword + '\'' +
                    ", searchKeyword='" + searchKeyword + '\'' +
                    ", installmentCount=" + installmentCount +
                    ", dwType=" + dwType +
                    ", currency='" + currency + '\'' +
                    ", balance=" + balance +
                    ", sender='" + sender + '\'' +
                    ", fullSms='" + fullSms + '\'' +
                    ", smsDate='" + smsDate + '\'' +
                    ", smsType=" + smsType +
                    ", isOffset=" + isOffset +
                    ", isDuplicate=" + isDuplicate +
                    ", memo='" + memo + '\'' +
                    ", spentLatitude=" + spentLatitude +
                    ", spentLongitude=" + spentLongitude +
                    ", categoryCode=" + categoryCode +
                    ", companyId=" + companyId +
                    ", classCode='" + classCode + '\'' +
                    ", regId=" + regId +
                    ", isCustom=" + isCustom +
                    ", isUserUpdate=" + isUserUpdate +
                    ", isUpdateAll=" + isUpdateAll +
                    ", isDeleted=" + isDeleted +
                    '}';
        }

        public Transaction(JoinedTransaction transaction, String uid) throws ParameterException {
            if(transaction == null || transaction.getCard() == null || transaction.getTransaction() == null || transaction.getCategory() == null ||
                    transaction.getUserCategory() == null) throw new ParameterException("transaction is null");

            this.uid = uid;

            setIdentifier(transaction.getTransaction().getIdentifier() + "");
            setCardName(transaction.getCard().getName());
            setCardType(transaction.getCard().getType());
            setCardSubType(transaction.getCard().getSubType());
            setSpentMoney(transaction.getTransaction().getSpentMoney());
            setOriSpentMoney(transaction.getTransaction().getOriSpentMoney());
            setSpentDate(transaction.getTransaction().getSpentDate());
            setFinishDate(transaction.getTransaction().getFinishDate());
            setOriKeyword(transaction.getTransaction().getKeyword());
            setSearchKeyword(transaction.getTransaction().getSearchKeyword());
            setInstallmentCount(transaction.getTransaction().getInstallmentCnt());
            setDwType(transaction.getTransaction().getDwType());
            setCurrency(transaction.getTransaction().getCurrency());
            setBalance(transaction.getCard().getBalance());
            setSender(transaction.getTransaction().getSender());
//            setFullSms(transaction.getTransaction().getFullSms());
            setSmsDate(transaction.getTransaction().getSmsDate());
            setSmsType(transaction.getTransaction().getSmsType());
            setIsOffset(transaction.getTransaction().isOffset() ? 1 : 0);
            setMemo(transaction.getTransaction().getMemo());
            setSpentLatitude(transaction.getTransaction().getLat());
            setSpentLongitude(transaction.getTransaction().getLng());
            setCategoryCode(transaction.getTransaction().getCategoryCode());
            setCompanyId(transaction.getTransaction().getCompanyId());
            setClassCode(transaction.getTransaction().getClassCode());
            setRegId(transaction.getTransaction().getRegId());
            setIsCustom(transaction.getTransaction().isCustom() ? 1 : 0);
            setIsUserUpdate(transaction.getTransaction().isUserUpdate() ? 1 : 0);
            setIsUpdateAll(transaction.getTransaction().isUpdateAll() ? 1 : 0);
            setIsDeleted(transaction.getTransaction().isDeleted() ? 1 : 0);

        }

        public String getIdentifier() {
            return identifier;
        }

        private void setIdentifier(String identifier) throws ParameterException {
            isStr(identifier, 50);
            this.identifier = identifier;
        }

        private void setCardName(String cardName) throws ParameterException {
            isStr(cardName, 50);
            this.cardName = cardName;
        }

        private void setCardNum(String cardNum) {
            this.cardNum = cardNum;
        }

        private void setCardType(int cardType) throws ParameterException {
            in(cardType, Constants.CardType.CHECK.ordinal(),
                    Constants.CardType.CARD.ordinal(),
                    Constants.CardType.BANK_ACCOUNT.ordinal(),
                    Constants.CardType.CASH
            .ordinal());

            this.cardType = cardType;
        }

        private void setCardSubType(int cardSubType) throws ParameterException {
            in(cardSubType, Constants.CardSubType.NORMAL.ordinal(),
                    Constants.CardSubType.CORPORATION.ordinal(),
                    Constants.CardSubType.FAMILY.ordinal());
            this.cardSubType = cardSubType;
        }

        private void setSpentMoney(double spentMoney) {
            this.spentMoney = spentMoney;
        }

        private void setOriSpentMoney(double oriSpentMoney) {
            if(oriSpentMoney == 0) oriSpentMoney = spentMoney;
            this.oriSpentMoney = oriSpentMoney;
        }

        private void setSpentDate(String spentDate) throws ParameterException {
            isDate(spentDate);
            this.spentDate = spentDate;
        }

        private void setFinishDate(String finishDate) {
            try {
                isDate(finishDate);
            } catch (ParameterException e) {
                finishDate = this.spentDate;
            }
            this.finishDate = finishDate;
        }

        private void setOriKeyword(String oriKeyword) throws ParameterException {
            isStr(oriKeyword, 50);
            this.oriKeyword = oriKeyword;
        }

        private void setSearchKeyword(String searchKeyword) throws ParameterException {
            isStr(oriKeyword, 50);
            this.searchKeyword = searchKeyword;
        }

        private void setInstallmentCount(int installmentCount) throws ParameterException {
            gt(installmentCount, 0);
            lt(installmentCount, 25);
            this.installmentCount = installmentCount == 0 ? 1 : installmentCount;
        }

        private void setDwType(int dwType) throws ParameterException {
            in(dwType, Constants.DWType.DEPOSIT.ordinal(), Constants.DWType.WITHDRAW.ordinal());
            this.dwType = dwType;
        }

        private void setCurrency(String currency) {
            this.currency = currency;
        }

        private void setBalance(double balance) {
            this.balance = balance;
        }

        private void setSender(String sender) throws ParameterException {
            isStr(sender, 50);
            this.sender = sender;
        }

        private void setFullSms(String fullSms) throws ParameterException {
            isStr(fullSms, 500);
            this.fullSms = fullSms;
        }

        private void setSmsDate(String smsDate) throws ParameterException {
            isDate(smsDate);
            this.smsDate = smsDate;
        }

        private void setSmsType(int smsType) throws ParameterException {
            in(smsType, Constants.SMSType.SMS.ordinal(), Constants.SMSType.MMS.ordinal(), Constants.SMSType.NOTIFICATION.ordinal());
            this.smsType = smsType;
        }

        private void setIsOffset(int isOffset) throws ParameterException {
            in(isOffset, 0, 1);

            this.isOffset = isOffset;
        }

        private void setIsDuplicate(int isDuplicate) throws ParameterException {
            in(isDuplicate, 0, 1);
            this.isDuplicate = isDuplicate;
        }

        private void setMemo(String memo) throws ParameterException {
            isStrWithNull(memo, 300);
            this.memo = memo;
        }

        private void setSpentLatitude(double spentLatitude) {
            this.spentLatitude = spentLatitude;
        }

        private void setSpentLongitude(double spentLongitude) {
            this.spentLongitude = spentLongitude;
        }

        private void setCategoryCode(int categoryCode) throws ParameterException {
            len("" + categoryCode, 6);
            this.categoryCode = categoryCode;
        }

        private void setCompanyId(int companyId) throws ParameterException {
            notZero(companyId);
            this.companyId = companyId;
        }

        private void setClassCode(String classCode) throws ParameterException {
            isStr(classCode, 10);
            this.classCode = classCode;
        }

        private void setRegId(int regId) {
            this.regId = regId;
        }

        private void setIsCustom(int isCustom) throws ParameterException {
            in(isCustom, 0, 1);
            this.isCustom = isCustom;
        }

        private void setIsUserUpdate(int isUserUpdate) throws ParameterException {
            in(isUserUpdate, 0, 1);
            this.isUserUpdate = isUserUpdate;
        }

        private void setIsUpdateAll(int isUpdateAll) throws ParameterException {
            in(isUpdateAll, 0, 1);
            this.isUpdateAll = isUpdateAll;
        }

        private void setIsDeleted(int isDeleted) throws ParameterException {
            in(isDeleted, 0, 1);
            this.isDeleted = isDeleted;
        }

    }

}
