package com.tenqube.visual_third.manager.downloader;

import android.content.Context;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import jxl.biff.ByteArray;

public class FileDownloader {


    private final Context context;


    private int BUFFER_SIZE = 4096;

    public FileDownloader(Context context) {
        this.context = context;
    }

    public File downloadFile(String fileURL) {

        File targetFile = null;

        URL url = null;
        try {
            url = new URL(fileURL);

            Log.i("VisualFlow", "downloadFile fileURL " + fileURL);

            HttpURLConnection httpConn = (HttpURLConnection) url.openConnection();
            int responseCode = httpConn.getResponseCode();
            // always check HTTP response code first
            if (responseCode == HttpURLConnection.HTTP_OK) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) { // extracts file name from header field
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(
                                index + 10,
                                disposition.length() - 1
                        );
                    }
                } else { // extracts file name from URL
                    fileName = fileURL.substring(
                            fileURL.lastIndexOf("/") + 1,
                            fileURL.length()
                    );
                }

                fileName = fileName.replace("2", "");

                Log.i("VisualFlow", "downloadFile fileName " + fileName);

                InputStream inputStream  = httpConn.getInputStream();


                targetFile = new File(context.getFilesDir(), fileName);

                FileOutputStream outputStream = new FileOutputStream(targetFile, false);
                int bytesRead;
                byte buffer[] = new byte[BUFFER_SIZE];

                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }

                outputStream.close();
                inputStream.close();
            }
            httpConn.disconnect();

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.i("VisualFlow", "downloadFile targetFile" + targetFile);

        return targetFile;


    }

}
