package com.tenqube.visual_third.api.resource;

import android.text.TextUtils;

import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;

import java.io.IOException;
import java.util.HashMap;

import retrofit2.Response;

public class ResourceServiceImpl implements ResourceService {

    private static final String TAG = ResourceServiceImpl.class.getSimpleName();

    private final ResourceApi resourceApi;

    private final SignatureManager signatureManager;

    private final PrefManager prefManager;

    private ResourceServiceImpl(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {

        this.resourceApi = resourceApi;
        this.signatureManager = signatureManager;
        this.prefManager = prefManager;
    }

    private static ResourceService mInstance;

    public static ResourceService getInstance(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi, signatureManager, prefManager);
            }
        }
        return mInstance;
    }

    private ApiInfo getApiInfo() {
        try {

            String apiInfoJson = prefManager.loadStringValue(PrefManager.API_INFO, "");
            if (TextUtils.isEmpty(apiInfoJson)) {
                HashMap<String, String> headers = new HashMap<>();
                headers.put("x-api-key", prefManager.loadStringValue(PrefManager.RESOURCE_API_KEY, ""));
                return new ApiInfo(prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers,
                        prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers,
                        prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers);
            } else {
                return Utils.fromJson(apiInfoJson, ApiInfo.class);
            }
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<SyncCategoryResponse> response = resourceApi.syncCategory(ResourceApi.CATEGORY,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {
                    return response.body();
                }
            } catch (Exception e) {

            }

        }

        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {

        try {
            Response<NotificationPkgResponse> response = resourceApi.syncNotificationApps().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;

    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<AnalysisResponse> response = resourceApi.syncAnalysis(ResourceApi.ANALYSIS,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {

                    return response.body();
                }
            } catch (Exception e) {

            }

        }

        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response<NotificationResponse> response = resourceApi.syncNotification().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {

        }

        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {

        try {
            Response<ParsingRuleKey> response = resourceApi.syncParsingRuleKey().execute();
            if (response != null) {
                if (response.isSuccessful()) {
                    return response.body();
                }
            }

        } catch (IOException e) {

        }
        return null;
    }

}
